library(rearrr)
context("helpers")


test_that("testing calculate_swirl_degrees_()", {
  xpectr::set_test_seed(42)

  # Generate expectations for 'calculate_swirl_degrees_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = calculate_swirl_degrees_,
  #   args_values = list(
  #     "distances" = list(runif(15), -runif(15), 0, NA),
  #     "radius" = list(0.5, -0.5, 1, 1.5, 0.001, 0, NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'calculate_swirl_degrees_'                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing calculate_swirl_degrees_(distances = runif(1...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- calculate_swirl_degrees_(distances = runif(15), radius = 0.5)
  # Testing class
  expect_equal(
    class(output_17375),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "double")
  # Testing values
  expect_equal(
    output_17375,
    c(329.33018, 337.34715, 103.01023, 298.96115, 231.02839, 186.87454,
      265.17179, 48.47998, 236.51722, 253.82332, 164.78704, 258.88041,
      336.48201, 91.95438, 166.42542),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    15L)

  # Testing calculate_swirl_degrees_(distances = -runif(...
  # Changed from baseline: distances = -runif(15)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(calculate_swirl_degrees_(distances = -runif(15), radius = 0.5), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("Assertion on 'distances' failed: Element 1 is not >= 0."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing calculate_swirl_degrees_(distances = 0, radi...
  # Changed from baseline: distances = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_13881 <- calculate_swirl_degrees_(distances = 0, radius = 0.5)
  # Testing class
  expect_equal(
    class(output_13881),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_13881,
    type = "double")
  # Testing values
  expect_equal(
    output_13881,
    0,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_13881),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_13881),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_13881)),
    1L)

  # Testing calculate_swirl_degrees_(distances = NA, rad...
  # Changed from baseline: distances = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(calculate_swirl_degrees_(distances = NA, radius = 0.5), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("Assertion on 'distances' failed: Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing calculate_swirl_degrees_(distances = NULL, r...
  # Changed from baseline: distances = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(calculate_swirl_degrees_(distances = NULL, radius = 0.5), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("Assertion on 'distances' failed: Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = -0.5
  xpectr::set_test_seed(42)
  # Assigning output
  output_18329 <- calculate_swirl_degrees_(distances = runif(15), radius = -0.5)
  # Testing class
  expect_equal(
    class(output_18329),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18329,
    type = "double")
  # Testing values
  expect_equal(
    output_18329,
    c(30.66982, 22.65285, 256.98977, 61.03885, 128.97161, 173.12546,
      94.82821, 311.52002, 123.48278, 106.17668, 195.21296, 101.11959,
      23.51799, 268.04562, 193.57458),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_18329),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18329),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18329)),
    15L)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_10073 <- calculate_swirl_degrees_(distances = runif(15), radius = 1)
  # Testing class
  expect_equal(
    class(output_10073),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_10073,
    type = "double")
  # Testing values
  expect_equal(
    output_10073,
    c(164.66509, 168.67357, 51.50512, 149.48057, 115.51419, 93.43727,
      132.5859, 24.23999, 118.25861, 126.91166, 82.39352, 129.44021,
      168.241, 45.97719, 83.21271),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_10073),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_10073),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_10073)),
    15L)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = 1.5
  xpectr::set_test_seed(42)
  # Assigning output
  output_12076 <- calculate_swirl_degrees_(distances = runif(15), radius = 1.5)
  # Testing class
  expect_equal(
    class(output_12076),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12076,
    type = "double")
  # Testing values
  expect_equal(
    output_12076,
    c(109.77673, 112.44905, 34.33674, 99.65372, 77.00946, 62.29151,
      88.3906, 16.15999, 78.83907, 84.60777, 54.92901, 86.29347, 112.16067,
      30.65146, 55.47514),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12076),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12076),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12076)),
    15L)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = 0.001
  xpectr::set_test_seed(42)
  # Assigning output
  output_19066 <- calculate_swirl_degrees_(distances = runif(15), radius = 0.001)
  # Testing class
  expect_equal(
    class(output_19066),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19066,
    type = "double")
  # Testing values
  expect_equal(
    output_19066,
    c(145.08783, 193.57439, 25.11626, 80.57269, 314.1934, 197.27084,
      105.89664, 119.9875, 178.61227, 191.66113, 313.51972, 200.2053,
      121.00449, 257.18838, 52.70806),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19066),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19066),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19066)),
    15L)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_16117 <- calculate_swirl_degrees_(distances = runif(15), radius = 0)
  # Testing class
  expect_equal(
    class(output_16117),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16117,
    type = "double")
  # Testing values
  expect_equal(
    output_16117,
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_16117),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16117),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16117)),
    15L)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13795 <- xpectr::capture_side_effects(calculate_swirl_degrees_(distances = runif(15), radius = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error']]),
    xpectr::strip("Assertion on 'radius' failed: May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing calculate_swirl_degrees_(distances = runif(1...
  # Changed from baseline: radius = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14357 <- xpectr::capture_side_effects(calculate_swirl_degrees_(distances = runif(15), radius = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['error']]),
    xpectr::strip("Assertion on 'radius' failed: Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'calculate_swirl_degrees_'                              ####
  #

})

test_that("testing add_dimensions_()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "a" = factor(LETTERS[1:10]),
    "b" = 1:10,
    "d" = runif(10),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'add_dimensions_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = add_dimensions_,
  #   args_values = list(
  #     "data" = list(df, 1:10, NA),
  #     "new_vectors" = list(setNames(list(1:10, 21:30), c("a", "e")),
  #                          list(1:10, 21:30),
  #                          setNames(list(1:9, 21:30), c("a", "e")),
  #                          setNames(list(c(NA, 1:9), 21:30), c("a", "e")),
  #                          setNames(list(list(1:10), list(21:30)), c("a", "e")),
  #                          "hej", NA),
  #     "suffix" = list("", ".mutated", 1, NA),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'add_dimensions_'                                                ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing add_dimensions_(data = df, new_vectors = set...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = "", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["b"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["a"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["e"]],
    c(21, 22, 23, 24, 25, 26, 27, 28, 29, 30),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("b", "d", "a", "e"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing add_dimensions_(data = 1:10, new_vectors = s...
  # Changed from baseline: data = 1:10
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(add_dimensions_(data = 1:10, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'integer'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = NA, new_vectors = set...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(add_dimensions_(data = NA, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = NULL, new_vectors = s...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(add_dimensions_(data = NULL, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = lis...
  # Changed from baseline: new_vectors = list(1:...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = list(1:10, 21:30), suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'new_vectors': Must have names."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: new_vectors = setName...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(1:9, 21:30), c("a", "e")), suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("arguments imply differing number of rows: 9, 10"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: new_vectors = setName...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- add_dimensions_(data = df, new_vectors = setNames(list(c(NA, 1:9), 21:30), c("a", "e")), suffix = "", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["b"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["d"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["a"]],
    c(NA, 1, 2, 3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["e"]],
    c(21, 22, 23, 24, 25, 26, 27, 28, 29, 30),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("b", "d", "a", "e"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("integer", "numeric", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("integer", "double", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(10L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: new_vectors = setName...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(list(1:10), list(21:30)), c("a", "e")), suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'new_vectors': May only contain the following types: {numeric,character,factor}, but element 1 has\n * type 'list'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = "he...
  # Changed from baseline: new_vectors = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = "hej", suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'new_vectors': Must be of type 'list', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = NA,...
  # Changed from baseline: new_vectors = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = NA, suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'new_vectors': Must be of type 'list', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = NUL...
  # Changed from baseline: new_vectors = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = NULL, suffix = "", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'new_vectors': Must be of type 'list', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: suffix = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = 1, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: suffix = ".mutated"
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = ".mutated", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_12554),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["a"]],
    structure(1:10, .Label = c("A", "B", "C", "D", "E", "F", "G", "H",
      "I", "J"), class = "factor"))
  expect_equal(
    output_12554[["b"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["d"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["a.mutated"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["e.mutated"]],
    c(21, 22, 23, 24, 25, 26, 27, 28, 29, 30),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("a", "b", "d", "a.mutated", "e.mutated"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("factor", "integer", "numeric", "integer", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("integer", "integer", "double", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(10L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = NULL, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = "", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: a."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing add_dimensions_(data = df, new_vectors = set...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(add_dimensions_(data = df, new_vectors = setNames(list(1:10, 21:30), c("a", "e")), suffix = "", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'overwrite': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'add_dimensions_'                                       ####
  #

})

test_that("testing list_coordinates_()", {
  xpectr::set_test_seed(42)

  # Generate expectations for 'list_coordinates_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = list_coordinates_,
  #   args_values = list(
  #     "coordinates" = list(c(1,5,8), list(1,5,8), 1, c("h",3,6), c(NA, 2, 4), c(4, 3), NA),
  #     "names" = list(c("x", "y", "z"), list("x", "y", "z"), c("x", "y"), NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'list_coordinates_'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing list_coordinates_(coordinates = c(1, 5, 8), ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- list_coordinates_(coordinates = c(1, 5, 8), names = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(c(x = 1, y = 5, z = 8)))
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)

  # Testing list_coordinates_(coordinates = list(1, 5, 8...
  # Changed from baseline: coordinates = list(1,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- list_coordinates_(coordinates = list(1, 5, 8), names = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_19370),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "list")
  # Testing values
  expect_equal(
    output_19370,
    list(list(x = 1, y = 5, z = 8)))
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    3L)

  # Testing list_coordinates_(coordinates = 1, names = c...
  # Changed from baseline: coordinates = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- list_coordinates_(coordinates = 1, names = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_12861),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "list")
  # Testing values
  expect_equal(
    output_12861,
    list(c(x = 1, y = 1, z = 1)))
  # Testing names
  expect_equal(
    names(output_12861),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    3L)

  # Testing list_coordinates_(coordinates = c("h", 3, 6)...
  # Changed from baseline: coordinates = c("h", ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(list_coordinates_(coordinates = c("h", 3, 6), names = c("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_numeric(coordinates): Must be of type 'numeric', not 'character'\n * checkmate::check_list(coordinates): Must be of type 'list', not 'character'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing list_coordinates_(coordinates = c(NA, 2, 4),...
  # Changed from baseline: coordinates = c(NA, 2...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- list_coordinates_(coordinates = c(NA, 2, 4), names = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_16417),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16417,
    type = "list")
  # Testing values
  expect_equal(
    output_16417,
    list(c(x = NA, y = 2, z = 4)))
  # Testing names
  expect_equal(
    names(output_16417),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16417),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16417)),
    3L)

  # Testing list_coordinates_(coordinates = c(4, 3), nam...
  # Changed from baseline: coordinates = c(4, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(list_coordinates_(coordinates = c(4, 3), names = c("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("When 'coordinates' has length >1, 'coordinates' and 'names' must have same length."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing list_coordinates_(coordinates = NA, names = ...
  # Changed from baseline: coordinates = NA
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- list_coordinates_(coordinates = NA, names = c("x", "y", "z"))
  # Testing class
  expect_equal(
    class(output_17365),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17365,
    type = "list")
  # Testing values
  expect_equal(
    output_17365,
    list(c(x = NA, y = NA, z = NA)))
  # Testing names
  expect_equal(
    names(output_17365),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17365),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17365)),
    3L)

  # Testing list_coordinates_(coordinates = NULL, names ...
  # Changed from baseline: coordinates = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(list_coordinates_(coordinates = NULL, names = c("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_numeric(coordinates): Must be of type 'numeric', not 'NULL'\n * checkmate::check_list(coordinates): Must be of type 'list', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing list_coordinates_(coordinates = c(1, 5, 8), ...
  # Changed from baseline: names = list("x", "y"...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(list_coordinates_(coordinates = c(1, 5, 8), names = list("x", "y", "z")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion on 'names' failed: Must be of type 'character', not 'list'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing list_coordinates_(coordinates = c(1, 5, 8), ...
  # Changed from baseline: names = c("x", "y")
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(list_coordinates_(coordinates = c(1, 5, 8), names = c("x", "y")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("When 'coordinates' has length >1, 'coordinates' and 'names' must have same length."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing list_coordinates_(coordinates = c(1, 5, 8), ...
  # Changed from baseline: names = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(list_coordinates_(coordinates = c(1, 5, 8), names = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("Assertion on 'names' failed: Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing list_coordinates_(coordinates = c(1, 5, 8), ...
  # Changed from baseline: names = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(list_coordinates_(coordinates = c(1, 5, 8), names = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("Assertion on 'names' failed: Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'list_coordinates_'                                     ####
  #

})

test_that("testing split_range_outliers_()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "g" = rep(1:4, each = 5)
  )

  # Generate expectations for 'split_range_outliers_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = split_range_outliers_,
  #   args_values = list(
  #     "data" = list(df, c(1,2,3)),
  #     "col" = list("x", c("x","y"), "z", NA),
  #     ".min" = list(.2, .4, NA, NULL),
  #     ".max" = list(0.8, .6, NA, NULL)
  #   ), extra_combinations = list(
  #     list(".min" = 0.0, ".max" = NULL),
  #     list(".min" = NULL, ".max" = 1.0)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'split_range_outliers_'                                           ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing split_range_outliers_(data = df, col = "x", ....
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- split_range_outliers_(data = df, col = "x", .min = 0.2, .max = 0.8)
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148[["data"]],
    structure(list(x = c(0.286139534786344, 0.641745518893003, 0.519095949130133,
      0.736588314641267, 0.656992290401831, 0.705064784036949, 0.45774177624844,
      0.719112251652405, 0.255428824340925, 0.462292822543532, 0.474997081561014,
      0.560332746244967), y = c(0.988891728920862, 0.0824375580996275,
      0.514211784349754, 0.390203467104584, 0.446969628101215, 0.836004259996116,
      0.737595617771149, 0.811055141268298, 0.685169729404151, 0.00394833879545331,
      0.906601407798007, 0.611778643447906), g = c(1L, 1L, 2L, 2L,
      2L, 2L, 3L, 3L, 3L, 3L, 4L, 4L)), row.names = c(3L, 5L, 6L,
      7L, 9L, 10L, 11L, 12L, 14L, 15L, 19L, 20L), class = "data.frame"))
  expect_equal(
    output_19148[["outliers"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.830447626067325,
      0.13466659723781, 0.934672247152776, 0.940014522755519, 0.978226428385824,
      0.117487361654639), y = c(0.904031387297437, 0.138710167724639,
      0.946668232558295, 0.905738130910322, 0.388108282815665, 0.832916080253199,
      0.00733414688147604, 0.207658972823992), g = c(1L, 1L, 1L, 2L,
      3L, 4L, 4L, 4L)), row.names = c(1L, 2L, 4L, 8L, 13L, 16L, 17L,
      18L), class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_19148),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_19148),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = c(1, 2, 3), col ...
  # Changed from baseline: data = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(split_range_outliers_(data = c(1, 2, 3), col = "x", .min = 0.2, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = NULL, col = "x",...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(split_range_outliers_(data = NULL, col = "x", .min = 0.2, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = c("x",...
  # Changed from baseline: col = c("x", "y")
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(split_range_outliers_(data = df, col = c("x", "y"), .min = 0.2, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'col': Must have length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "z", ....
  # Changed from baseline: col = "z"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(split_range_outliers_(data = df, col = "z", .min = 0.2, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * 'col' not found in 'data'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = NA, .m...
  # Changed from baseline: col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(split_range_outliers_(data = df, col = NA, .min = 0.2, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = NULL, ...
  # Changed from baseline: col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(split_range_outliers_(data = df, col = NULL, .min = 0.2, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .min = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- split_range_outliers_(data = df, col = "x", .min = NULL, .max = 0.8)
  # Testing class
  expect_equal(
    class(output_11346),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11346,
    type = "list")
  # Testing values
  expect_equal(
    output_11346[["data"]],
    structure(list(x = c(0.286139534786344, 0.641745518893003, 0.519095949130133,
      0.736588314641267, 0.13466659723781, 0.656992290401831, 0.705064784036949,
      0.45774177624844, 0.719112251652405, 0.255428824340925, 0.462292822543532,
      0.117487361654639, 0.474997081561014, 0.560332746244967), y = c(0.988891728920862,
      0.0824375580996275, 0.514211784349754, 0.390203467104584, 0.905738130910322,
      0.446969628101215, 0.836004259996116, 0.737595617771149, 0.811055141268298,
      0.685169729404151, 0.00394833879545331, 0.207658972823992, 0.906601407798007,
      0.611778643447906), g = c(1L, 1L, 2L, 2L, 2L, 2L, 2L, 3L, 3L,
      3L, 3L, 4L, 4L, 4L)), row.names = c(3L, 5L, 6L, 7L, 8L, 9L,
      10L, 11L, 12L, 14L, 15L, 18L, 19L, 20L), class = "data.frame"))
  expect_equal(
    output_11346[["outliers"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.830447626067325,
      0.934672247152776, 0.940014522755519, 0.978226428385824), y = c(0.904031387297437,
      0.138710167724639, 0.946668232558295, 0.388108282815665, 0.832916080253199,
      0.00733414688147604), g = c(1L, 1L, 1L, 3L, 4L, 4L)), row.names = c(1L,
      2L, 4L, 13L, 16L, 17L), class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_11346),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11346),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11346)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_11346),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .min = 0.4
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- split_range_outliers_(data = df, col = "x", .min = 0.4, .max = 0.8)
  # Testing class
  expect_equal(
    class(output_16569),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16569,
    type = "list")
  # Testing values
  expect_equal(
    output_16569[["data"]],
    structure(list(x = c(0.641745518893003, 0.519095949130133, 0.736588314641267,
      0.656992290401831, 0.705064784036949, 0.45774177624844, 0.719112251652405,
      0.462292822543532, 0.474997081561014, 0.560332746244967), y = c(0.0824375580996275,
      0.514211784349754, 0.390203467104584, 0.446969628101215, 0.836004259996116,
      0.737595617771149, 0.811055141268298, 0.00394833879545331, 0.906601407798007,
      0.611778643447906), g = c(1L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 4L,
      4L)), row.names = c(5L, 6L, 7L, 9L, 10L, 11L, 12L, 15L, 19L,
      20L), class = "data.frame"))
  expect_equal(
    output_16569[["outliers"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.286139534786344,
      0.830447626067325, 0.13466659723781, 0.934672247152776, 0.255428824340925,
      0.940014522755519, 0.978226428385824, 0.117487361654639), y = c(0.904031387297437,
      0.138710167724639, 0.988891728920862, 0.946668232558295, 0.905738130910322,
      0.388108282815665, 0.685169729404151, 0.832916080253199, 0.00733414688147604,
      0.207658972823992), g = c(1L, 1L, 1L, 1L, 2L, 3L, 3L, 4L, 4L,
      4L)), row.names = c(1L, 2L, 3L, 4L, 8L, 13L, 14L, 16L, 17L,
      18L), class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_16569),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16569),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16569)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_16569),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .min = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(split_range_outliers_(data = df, col = "x", .min = NA, .max = 0.8), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .min, .max
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- split_range_outliers_(data = df, col = "x", .min = 0, .max = NULL)
  # Testing class
  expect_equal(
    class(output_14577),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14577,
    type = "list")
  # Testing values
  expect_equal(
    output_14577[["data"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.286139534786344,
      0.830447626067325, 0.641745518893003, 0.519095949130133, 0.736588314641267,
      0.13466659723781, 0.656992290401831, 0.705064784036949, 0.45774177624844,
      0.719112251652405, 0.934672247152776, 0.255428824340925, 0.462292822543532,
      0.940014522755519, 0.978226428385824, 0.117487361654639, 0.474997081561014,
      0.560332746244967), y = c(0.904031387297437, 0.138710167724639,
      0.988891728920862, 0.946668232558295, 0.0824375580996275, 0.514211784349754,
      0.390203467104584, 0.905738130910322, 0.446969628101215, 0.836004259996116,
      0.737595617771149, 0.811055141268298, 0.388108282815665, 0.685169729404151,
      0.00394833879545331, 0.832916080253199, 0.00733414688147604,
      0.207658972823992, 0.906601407798007, 0.611778643447906), g = c(1L,
      1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 4L,
      4L, 4L, 4L, 4L)), class = "data.frame", row.names = c(NA, -20L)))
  expect_equal(
    output_14577[["outliers"]],
    structure(list(x = numeric(0), y = numeric(0), g = integer(0)),
      row.names = integer(0), class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_14577),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14577),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14577)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_14577),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .min, .max
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- split_range_outliers_(data = df, col = "x", .min = NULL, .max = 1)
  # Testing class
  expect_equal(
    class(output_17191),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17191,
    type = "list")
  # Testing values
  expect_equal(
    output_17191[["data"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.286139534786344,
      0.830447626067325, 0.641745518893003, 0.519095949130133, 0.736588314641267,
      0.13466659723781, 0.656992290401831, 0.705064784036949, 0.45774177624844,
      0.719112251652405, 0.934672247152776, 0.255428824340925, 0.462292822543532,
      0.940014522755519, 0.978226428385824, 0.117487361654639, 0.474997081561014,
      0.560332746244967), y = c(0.904031387297437, 0.138710167724639,
      0.988891728920862, 0.946668232558295, 0.0824375580996275, 0.514211784349754,
      0.390203467104584, 0.905738130910322, 0.446969628101215, 0.836004259996116,
      0.737595617771149, 0.811055141268298, 0.388108282815665, 0.685169729404151,
      0.00394833879545331, 0.832916080253199, 0.00733414688147604,
      0.207658972823992, 0.906601407798007, 0.611778643447906), g = c(1L,
      1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 4L,
      4L, 4L, 4L, 4L)), class = "data.frame", row.names = c(NA, -20L)))
  expect_equal(
    output_17191[["outliers"]],
    structure(list(x = numeric(0), y = numeric(0), g = integer(0)),
      row.names = integer(0), class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_17191),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17191),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17191)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_17191),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .max = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- split_range_outliers_(data = df, col = "x", .min = 0.2, .max = NULL)
  # Testing class
  expect_equal(
    class(output_19346),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19346,
    type = "list")
  # Testing values
  expect_equal(
    output_19346[["data"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.286139534786344,
      0.830447626067325, 0.641745518893003, 0.519095949130133, 0.736588314641267,
      0.656992290401831, 0.705064784036949, 0.45774177624844, 0.719112251652405,
      0.934672247152776, 0.255428824340925, 0.462292822543532, 0.940014522755519,
      0.978226428385824, 0.474997081561014, 0.560332746244967), y = c(0.904031387297437,
      0.138710167724639, 0.988891728920862, 0.946668232558295, 0.0824375580996275,
      0.514211784349754, 0.390203467104584, 0.446969628101215, 0.836004259996116,
      0.737595617771149, 0.811055141268298, 0.388108282815665, 0.685169729404151,
      0.00394833879545331, 0.832916080253199, 0.00733414688147604,
      0.906601407798007, 0.611778643447906), g = c(1L, 1L, 1L, 1L,
      1L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L)), row.names = c(1L,
      2L, 3L, 4L, 5L, 6L, 7L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L,
      17L, 19L, 20L), class = "data.frame"))
  expect_equal(
    output_19346[["outliers"]],
    structure(list(x = c(0.13466659723781, 0.117487361654639), y = c(0.905738130910322,
      0.207658972823992), g = c(2L, 4L)), row.names = c(8L, 18L),
      class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_19346),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19346),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19346)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_19346),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .max = 0.6
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- split_range_outliers_(data = df, col = "x", .min = 0.2, .max = 0.6)
  # Testing class
  expect_equal(
    class(output_12554),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12554,
    type = "list")
  # Testing values
  expect_equal(
    output_12554[["data"]],
    structure(list(x = c(0.286139534786344, 0.519095949130133, 0.45774177624844,
      0.255428824340925, 0.462292822543532, 0.474997081561014, 0.560332746244967),
      y = c(0.988891728920862, 0.514211784349754, 0.737595617771149,
          0.685169729404151, 0.00394833879545331, 0.906601407798007,
          0.611778643447906), g = c(1L, 2L, 3L, 3L, 3L, 4L, 4L)),
      row.names = c(3L, 6L, 11L, 14L, 15L, 19L, 20L), class = "data.frame"))
  expect_equal(
    output_12554[["outliers"]],
    structure(list(x = c(0.914806043496355, 0.937075413297862, 0.830447626067325,
      0.641745518893003, 0.736588314641267, 0.13466659723781, 0.656992290401831,
      0.705064784036949, 0.719112251652405, 0.934672247152776, 0.940014522755519,
      0.978226428385824, 0.117487361654639), y = c(0.904031387297437,
      0.138710167724639, 0.946668232558295, 0.0824375580996275, 0.390203467104584,
      0.905738130910322, 0.446969628101215, 0.836004259996116, 0.811055141268298,
      0.388108282815665, 0.832916080253199, 0.00733414688147604, 0.207658972823992),
      g = c(1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 3L, 3L, 4L, 4L, 4L)),
      row.names = c(1L, 2L, 4L, 5L, 7L, 8L, 9L, 10L, 12L, 13L, 16L,
          17L, 18L), class = "data.frame"))
  # Testing names
  expect_equal(
    names(output_12554),
    c("data", "outliers"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12554),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12554)),
    6L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("data.frame", "data.frame"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_12554),
    c("list", "list"),
    fixed = TRUE)

  # Testing split_range_outliers_(data = df, col = "x", ....
  # Changed from baseline: .max = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(split_range_outliers_(data = df, col = "x", .min = 0.2, .max = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'split_range_outliers_'                                  ####
  #

})
