% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrangers.R
\name{extreme_triplet_grouping_rearranger_}
\alias{extreme_triplet_grouping_rearranger_}
\title{Wrapper for running extreme triplet grouping}
\usage{
extreme_triplet_grouping_rearranger_(
  data,
  col = NULL,
  middle_is = "middle",
  unequal_method_1 = "middle",
  unequal_method_2 = c("middle", "middle"),
  order_by_aggregates = FALSE,
  shuffle_members = FALSE,
  shuffle_triplets = FALSE,
  num_groupings = 1,
  balance = "mean",
  factor_name = ".triplet",
  overwrite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{col}{Column to create sorting factor by.
When \code{`NULL`} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{middle_is}{Whether the middle element in the triplet is the nth closest element
to the median value or the nth+1 lowest/highest value.

One of: \code{middle} (default), \code{min}, or \code{max}.

Triplet grouping is performed greedily from the most extreme values to the least extreme
values. E.g. \code{c(1, 6, 12)} is created before \code{c(2, 5, 11)} which is made
before \code{c(3, 7, 10)}.

\strong{Examples}:

When \code{`middle_is` == 'middle'}, a \code{1:12} sequence is grouped into:

\code{c( c(1, 6, 12), c(2, 7, 11), c(3, 5, 10),  c(4, 8, 9) )}

When \code{`middle_is` == 'min'}, a \code{1:12} sequence is grouped into:

\code{c( c(1, 2, 12), c(3, 4, 11), c(5, 6, 10),  c(7, 8, 9) )}

When \code{`middle_is` == 'max'}, a \code{1:12} sequence is grouped into:

\code{c( c(1, 11, 12), c(2, 9, 10), c(3, 7, 8),  c(4, 5, 6) )}}

\item{order_by_aggregates}{Whether to order the groups from initial groupings (first \code{`num_groupings` - 1})
by their aggregate values instead of their group identifiers.

N.B. Only used when \code{`num_groupings` > 1}.}

\item{shuffle_members}{Whether to shuffle the order of the group members within the groups. (Logical)}

\item{shuffle_triplets}{Whether to shuffle the order of the triplets. Triplet members remain together. (Logical)}

\item{num_groupings}{Number of times to group into triplets (recursively). At least \code{1}.

Based on \code{`balance`}, the secondary groupings perform extreme triplet grouping on either the
\emph{sum}, \emph{absolute difference}, \emph{min}, or \emph{max} of the triplet elements.}

\item{balance}{What to balance triplets for in a given \emph{secondary} triplet grouping.
Either \code{"mean"}, \code{"spread"}, \code{"min"}, or \code{"max"}.
Can be a single string used for all secondary groupings
or one for each secondary grouping (\code{`num_groupings` - 1}).

The first triplet grouping always groups the actual element values.

\subsection{mean}{
Triplets have similar means. The values in the triplets from the previous grouping
are aggregated with \code{`sum()`} and extreme triplet grouped.
}
\subsection{spread}{
Triplets have similar spread (e.g. standard deviations). The values in the triplets
from the previous triplet grouping are aggregated with \code{`sum(abs(diff()))`} and
extreme triplet grouped.
}
\subsection{min / max}{
Triplets have similar minimum / maximum values. The values in the triplets from the
previous triplet grouping are aggregated with \code{`min()`} / \code{`max()`} and extreme
triplet grouped.
}}

\item{factor_name}{Name of new column with the sorting factor.
If \code{`NULL`}, no column is added.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
Optionally with the sorting factor(s) added.

When \code{`data`} is a \code{vector} and \code{`factor_name`} is \code{`NULL`},
the output will be a \code{vector}. Otherwise, a \code{data.frame}.
}
\description{
Wrapper for running extreme triplet grouping
}
\keyword{internal}
