% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{sampleCMB}
\alias{sampleCMB}
\title{Take a simple random sample from a \code{\link{CMBDataFrame}}}
\usage{
sampleCMB(cmbdf, sample.size)
}
\arguments{
\item{cmbdf}{a \code{\link{CMBDataFrame}}.}

\item{sample.size}{the desired sample size.}
}
\value{
A \code{\link{CMBDataFrame}} which size equals to sample.size,
whose rows comprise a simple random sample of the rows
from the input CMBDataFrame.
}
\description{
This function returns a \code{\link{CMBDataFrame}} which size equals to sample.size,
whose rows comprise a simple random sample of the rows
from the input CMBDataFrame.
}
\examples{
## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# plot(sampleCMB(df, sample.size = 800000))

df <- CMBDataFrame(nside = 16, I = rnorm(12 * 16 ^ 2), ordering = "nested")
df.sample <- sampleCMB(df, sample.size = 100)
df.sample

}
