% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Downloaders.R
\name{downloadCMBMap}
\alias{downloadCMBMap}
\title{Download CMB Maps from Planck Public Data Release.}
\usage{
downloadCMBMap(foreground = "smica", nside = 1024, destfile)
}
\arguments{
\item{foreground}{A string naming the foreground separation method pipeline.
Please choose one of "COMMANDER", "NILC", "SEVEM" or "SMICA"
(not case sensitive).}

\item{nside}{An integer. The nside parameter (resolution) required.
The available options are \code{1024} or \code{2048}.}

\item{destfile}{An optional character string with the path and file
name for the downloaded file to be saved. Defaults to the working
directory. Tilde-expansion is performed.}
}
\value{
CMB Map FITS File (Flexible Image Transport System). The
FITS file can be loaded into a \code{\link{CMBDataFrame}} using
the \code{\link{CMBDataFrame}} function (see examples).
}
\description{
The function \code{downloadCMBMap} downloads CMB maps from
\url{http://irsa.ipac.caltech.edu/data/Planck/release_2/all-sky-maps/matrix_cmb.html}.
}
\details{
CMB maps have been produced by the COMMANDER, NILC, SEVEM, and SMICA
pipelines, respectively.

For each pipeline, the intensity maps are provided at Nside = 2048, at
5 arcmin resolution, and the polarization maps are provided at Nside = 1024
at 10 arcmin resolution.
}
\examples{
## Download SMICA with \\code{nside = 1024}
## and save in working directory
## as "CMB_map_smica1024.fits"
# downloadCMBMap(foreground = "smica", nside = 1024)
## Load the downloaded map into a CMBDataFrame
# sky <- CMBDataFrame("CMB_map_smica1024.fits")

## Download SMICA with Nside=2048 and save in the working directory
## as "CMB_map_smica2048.fits"
# downloadCMBMap(foreground = "smica", nside = 2048)

## Download COMMANDER with Nside=1024 and save in a specified folder,
## for example,
# dest <- "CMB_map_commander1024.fits"
# downloadCMBMap(foreground = "commander", nside = 1024, destfile = dest)

}
\references{
Planck Public Data Release 2 Maps
\url{http://irsa.ipac.caltech.edu/data/Planck/release_2/all-sky-maps/matrix_cmb.html}

Other fits maps can also be downloaded
using the general command \code{\link{download.file}}.
}
