% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt-constant-folding.R
\name{opt_constant_folding}
\alias{opt_constant_folding}
\title{Optimizer: Constant Folding.}
\usage{
opt_constant_folding(texts, fold_floats = FALSE, in_fun_call = FALSE)
}
\arguments{
\item{texts}{A list of character vectors with the code to optimize.}

\item{fold_floats}{A logical indicating if floating-point results should be
folded (will reduce precision).}

\item{in_fun_call}{A logical indicating whether it should propagate in
function calls. Note: this could change the semantics of the program.}
}
\description{
Performs one constant folding pass.
Carefully examine the results after running this function!
}
\examples{
code <- paste(
  "i <- 320 * 200 * 32",
  "x <- i * 20 + 100",
  sep = "\n"
)
cat(opt_constant_folding(list(code))$codes[[1]])
}
