% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_noncircular.R
\name{expand_noncircular}
\alias{expand_noncircular}
\title{Expand non-circular}
\usage{
expand_noncircular(caim, z, zenith_colrow)
}
\arguments{
\item{caim}{\linkS4class{SpatRaster}. The return of a call to \code{\link[=read_caim]{read_caim()}} or
\code{\link[=read_caim_raw]{read_caim_raw()}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{zenith_colrow}{Numeric vector of length two. Raster coordinates of the
zenith. See \code{\link[=calc_zenith_colrow]{calc_zenith_colrow()}}.}
}
\value{
An object of class \linkS4class{SpatRaster} that is the result of adding
margins (\code{NA} pixels) to \code{caim}. The zenith point depicted in the picture
should be in the center of the image or very close to it.
}
\description{
Expand a non-circular hemispherical photograph.
}
\examples{
\dontrun{

 # ====================================================================
 # Non-circular Fisheye images from a Smartphone with an Auxiliary Lens
 # (Also applicable to Non-circular images from DSLR cameras)
 # ====================================================================

 path <- system.file("external/APC_0581.jpg", package = "rcaiman")
 caim <- read_caim(path)
 z <- zenith_image(2132/2,  c(0.7836, 0.1512, -0.1558))
 a <- azimuth_image(z)
 zenith_colrow <- c(1063, 771)/2
 caim <- expand_noncircular(caim, z, zenith_colrow)
 plot(caim$Blue, col = seq(0,1,1/255) \%>\% grey())
 m <- !is.na(caim$Red) & !is.na(z)
 plot(m, add = TRUE, alpha = 0.3, legend = FALSE)


 # ============================
 # Restricted View Canopy Photo
 # ============================

 path <- system.file("external/APC_0020.jpg", package = "rcaiman")
 caim <- read_caim(path)
 plot(caim)
 caim <- normalize(caim)
 diameter <- calc_diameter(lens(), sqrt(nrow(caim)^2 + ncol(caim)^2)/2, 90)
 z <- zenith_image(diameter, lens())
 caim <- expand_noncircular(caim, z, c(ncol(caim)/2, nrow(caim)/2))
 m <- !is.na(caim$Red)
 a <- azimuth_image(z)
 caim[!m] <- 0
 z <- normalize(z, 0, 90) * 30.15 #60.3º diagonal FOV according to metadata
 plot(caim$Blue, col = seq(0,1,1/255) \%>\% grey())
 m <- !is.na(caim$Red) & !is.na(z)
 plot(m, add = TRUE, alpha = 0.3, legend = FALSE)
}
}
\seealso{
Other Lens Functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_relative_radius}()},
\code{\link{calc_zenith_colrow}()},
\code{\link{calibrate_lens}()},
\code{\link{crosscalibrate_lens}()},
\code{\link{extract_radiometry}()},
\code{\link{fisheye_to_equidistant}()},
\code{\link{fisheye_to_pano}()},
\code{\link{lens}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens Functions}
