% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data3d.R
\name{Data3D}
\alias{Data3D}
\alias{get_data3d_data}
\alias{get_data3d_values}
\alias{get_data3d_value}
\alias{put_data3d_data}
\alias{put_data3d_values}
\alias{put_data3d_value}
\alias{read_data3d_value}
\alias{write_data3d_value}
\title{Read and write Data3D data}
\usage{
get_data3d_data(db, x, z, dimension)

get_data3d_values(db, x, z, dimension)

get_data3d_value(db, x, z, dimension)

put_data3d_data(db, data)

put_data3d_values(db, x, z, dimension, height_maps, biome_maps)

put_data3d_value(db, x, z, dimension, height_map, biome_map)

read_data3d_value(rawdata)

write_data3d_value(height_map, biome_map)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{data}{A named-vector of key-value pairs for Data3D data.}

\item{height_maps, biome_maps}{Lists of height and biome data.
Values will be recycled if necessary to match the number of keys
to be written to. If \code{biome_maps} is missing, \code{height_maps} should
be in the same format as returned by \code{get_data3d_data()}.}

\item{height_map}{16x16 array containing height data.
Values will be recycled if necessary. If \code{biome_map} is missing, \code{height-map}
should be a list a \code{list()} with both "height_map" and "biome_map" elements.}

\item{biome_map}{16xNx16 array containing biome data.}

\item{rawdata}{A raw vector.}
}
\value{
\code{get_data3d_data()} returns a list of the of the values returned by
\code{get_data3d_value()}.

\code{get_data3d_value()} returns a list with components "height_map"
and "biome_map".
}
\description{
Data3D data (tag 43) stores information about surface heights and biomes in a
chunk.

\code{get_data3d_data()} loads Data3D data from \code{db}.
It will silently drop keys not representing Data3D data.

\code{get_data3d_value()} loads Data3D data from \code{db}.
It only supports loading a single value.

\code{put_data3d_data()}, \code{put_data3d_values()}, and
\code{put_data3d_value()} store Data3D data into \code{db}.

\code{read_data3d_value()} decodes binary Data3D data.

\code{write_data3d_value} encodes Data3D data into a raw vector.
}
