% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-LFP_electrode.R
\name{LFP_electrode}
\alias{LFP_electrode}
\title{Definitions of reference with 'LFP' signal type}
\description{
Please use a safer \code{\link{new_electrode}} function to
create instances. This documentation is to describe the member methods
of the electrode class \code{LFP_electrode}
}
\examples{
\dontrun{

# Download subject demo/DemoSubject


# Electrode 14 in demo/DemoSubject
subject <- as_rave_subject("demo/DemoSubject")
e <- new_electrode(subject = subject, number = 14, signal_type = "LFP")

# Load CAR reference "ref_13-16,24"
ref <- new_reference(subject = subject, number = "ref_13-16,24",
                     signal_type = "LFP")
e$set_reference(ref)

# Set epoch
e$set_epoch(epoch = 'auditory_onset')

# Set loading window
e$trial_intervals <- list(c(-1, 2))

# Preview
print(e)

# Now epoch power
power <- e$load_data("power")
names(dimnames(power))

# Subset power
subset(power, Time ~ Time < 0, Electrode ~ Electrode == 14)

# Draw baseline
tempfile <- tempfile()
bl <- power_baseline(power, baseline_windows = c(-1, 0),
                     method = "decibel", filebase = tempfile)
collapsed_power <- collapse2(bl, keep = c(2,1))
# Visualize
dname <- dimnames(bl)
image(collapsed_power, x = dname$Time, y = dname$Frequency,
      xlab = "Time (s)", ylab = "Frequency (Hz)",
      main = "Mean power over trial (Baseline: -1~0 seconds)",
      sub = glue('Electrode {e$number} (Reference: {ref$number})'))
abline(v = 0, lty = 2, col = 'blue')
text(x = 0, y = 20, "Audio onset", col = "blue", cex = 0.6)

# clear cache on hard disk
e$clear_cache()
ref$clear_cache()

}

}
\section{Super class}{
\code{\link[raveio:RAVEAbstarctElectrode]{raveio::RAVEAbstarctElectrode}} -> \code{LFP_electrode}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{h5_fname}}{'HDF5' file name}

\item{\code{valid}}{whether current electrode is valid: subject exists and
contains current electrode or reference; subject electrode type matches
with current electrode type}

\item{\code{raw_sample_rate}}{voltage sample rate}

\item{\code{power_sample_rate}}{power/phase sample rate}

\item{\code{preprocess_info}}{preprocess information}

\item{\code{power_file}}{path to power 'HDF5' file}

\item{\code{phase_file}}{path to phase 'HDF5' file}

\item{\code{voltage_file}}{path to voltage 'HDF5' file}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LFP_electrode-print}{\code{LFP_electrode$print()}}
\item \href{#method-LFP_electrode-set_reference}{\code{LFP_electrode$set_reference()}}
\item \href{#method-LFP_electrode-new}{\code{LFP_electrode$new()}}
\item \href{#method-LFP_electrode-.load_noref_wavelet}{\code{LFP_electrode$.load_noref_wavelet()}}
\item \href{#method-LFP_electrode-.load_noref_voltage}{\code{LFP_electrode$.load_noref_voltage()}}
\item \href{#method-LFP_electrode-.load_wavelet}{\code{LFP_electrode$.load_wavelet()}}
\item \href{#method-LFP_electrode-.load_voltage}{\code{LFP_electrode$.load_voltage()}}
\item \href{#method-LFP_electrode-load_data}{\code{LFP_electrode$load_data()}}
\item \href{#method-LFP_electrode-load_blocks}{\code{LFP_electrode$load_blocks()}}
\item \href{#method-LFP_electrode-clear_cache}{\code{LFP_electrode$clear_cache()}}
\item \href{#method-LFP_electrode-clear_memory}{\code{LFP_electrode$clear_memory()}}
\item \href{#method-LFP_electrode-clone}{\code{LFP_electrode$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="raveio" data-topic="RAVEAbstarctElectrode" data-id="set_epoch"><a href='../../raveio/html/RAVEAbstarctElectrode.html#method-RAVEAbstarctElectrode-set_epoch'><code>raveio::RAVEAbstarctElectrode$set_epoch()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-print"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-print}{}}}
\subsection{Method \code{print()}}{
print electrode summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-set_reference"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-set_reference}{}}}
\subsection{Method \code{set_reference()}}{
set reference for current electrode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$set_reference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{either \code{NULL} or \code{LFP_electrode} instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-new"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$new(subject, number)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject, number, is_reference}}{see constructor in
\code{\link{RAVEAbstarctElectrode}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-.load_noref_wavelet"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-.load_noref_wavelet}{}}}
\subsection{Method \code{.load_noref_wavelet()}}{
load non-referenced wavelet coefficients (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_noref_wavelet(reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
if the reference number if \code{NULL} or \code{'noref'}, then
returns 0, otherwise returns a \code{\link[filearray]{FileArray-class}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-.load_noref_voltage"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-.load_noref_voltage}{}}}
\subsection{Method \code{.load_noref_voltage()}}{
load non-referenced voltage (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_noref_voltage(reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reload}}{whether to reload cache}

\item{\code{srate}}{voltage signal sample rate}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-.load_wavelet"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-.load_wavelet}{}}}
\subsection{Method \code{.load_wavelet()}}{
load referenced wavelet coefficients (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_wavelet(type = c("power", "phase", "coef"), reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{type of data to load}

\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-.load_voltage"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-.load_voltage}{}}}
\subsection{Method \code{.load_voltage()}}{
load referenced voltage (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$.load_voltage(reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reload}}{whether to reload cache}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-load_data"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-load_data}{}}}
\subsection{Method \code{load_data()}}{
method to load electrode data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$load_data(
  type = c("power", "phase", "voltage", "wavelet-coefficient")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{data type such as \code{"power"}, \code{"phase"},
\code{"voltage"}, \code{"wavelet-coefficient"}. Note that if type
is voltage, then 'Notch' filters must be applied; otherwise 'Wavelet'
transforms are required.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-load_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-load_blocks}{}}}
\subsection{Method \code{load_blocks()}}{
load electrode block-wise data (with no reference),
useful when epoch is absent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$load_blocks(
  blocks,
  type = c("power", "phase", "voltage", "wavelet-coefficient"),
  simplify = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks}}{session blocks}

\item{\code{type}}{data type such as \code{"power"}, \code{"phase"},
\code{"voltage"}, \code{"wavelet-coefficient"}. Note that if type
is voltage, then 'Notch' filters must be applied; otherwise 'Wavelet'
transforms are required.}

\item{\code{simplify}}{whether to simplify the result}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{simplify} is enabled, and only one block is loaded,
then the result will be a vector (\code{type="voltage"}) or a matrix
(others), otherwise the result will be a named list where the names
are the blocks.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
method to clear cache on hard drive
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$clear_cache(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-clear_memory"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-clear_memory}{}}}
\subsection{Method \code{clear_memory()}}{
method to clear memory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$clear_memory(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LFP_electrode-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LFP_electrode-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LFP_electrode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
