% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforest.R
\name{rforest}
\alias{rforest}
\title{Random Forest using Ranger}
\usage{
rforest(
  dataset,
  rvar,
  evar,
  type = "classification",
  lev = "",
  mtry = NULL,
  num.trees = 100,
  min.node.size = 1,
  sample.fraction = 1,
  replace = NULL,
  num.threads = 12,
  wts = "None",
  seed = NA,
  data_filter = "",
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{type}{Model type (i.e., "classification" or "regression")}

\item{lev}{Level to use as the first column in prediction output}

\item{mtry}{Number of variables to possibly split at in each node. Default is the (rounded down) square root of the number variables}

\item{num.trees}{Number of trees to create}

\item{min.node.size}{Minimal node size}

\item{sample.fraction}{Fraction of observations to sample. Default is 1 for sampling with replacement and 0.632 for sampling without replacement}

\item{replace}{Sample with (TRUE) or without (FALSE) replacement. If replace is NULL it will be reset to TRUE if the sample.fraction is equal to 1 and will be set to FALSE otherwise}

\item{num.threads}{Number of parallel threads to use. Defaults to 12 if available}

\item{wts}{Case weights to use in estimation}

\item{seed}{Random seed to use as the starting point}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}

\item{...}{Further arguments to pass to ranger}
}
\value{
A list with all variables defined in rforest as an object of class rforest
}
\description{
Random Forest using Ranger
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/rforest.html} for an example in Radiant
}
\examples{
rforest(titanic, "survived", c("pclass", "sex"), lev = "Yes") \%>\% summary()
rforest(titanic, "survived", c("pclass", "sex")) \%>\% str()
rforest(titanic, "survived", c("pclass", "sex"), max.depth = 1)
rforest(diamonds, "price", c("carat", "clarity"), type = "regression") \%>\% summary()

}
\seealso{
\code{\link{summary.rforest}} to summarize results

\code{\link{plot.rforest}} to plot results

\code{\link{predict.rforest}} for prediction
}
