% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtree.R
\name{plot.crtree}
\alias{plot.crtree}
\title{Plot method for the crtree function}
\usage{
\method{plot}{crtree}(x, plots = "tree", orient = "LR",
  width = "900px", labs = TRUE, dec = 2, shiny = FALSE,
  custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{crtree}}}

\item{plots}{Plots to produce for the specified rpart tree. "tree" shows a tree diagram. "prune" shows a line graph to evaluate appropriate tree pruning. "imp" shows a variable importance plot}

\item{orient}{Plot orientation for tree: LR for vertical and TD for horizontal}

\item{width}{Plot width in pixels for tree (default is "900px")}

\item{labs}{Use factor labels in plot (TRUE) or revert to default letters used by tree (FALSE)}

\item{dec}{Decimal places to round results to}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the crtree function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/crtree.html} for an example in Radiant. The standard tree plot used by by the rpart package can be generated by \code{plot.rpart(result$model)}. See \code{\link{plot.rpart}} for additional details.
}
\examples{
result <- crtree(titanic, "survived", c("pclass", "sex"), lev = "Yes")
plot(result)
result <- crtree(diamonds, "price", c("carat", "clarity", "cut"))
plot(result, plots = "prune")
result <- crtree(dvd, "buy", c("coupon", "purch", "last"), cp = .01)
plot(result, plots = "imp")

}
\seealso{
\code{\link{crtree}} to generate results

\code{\link{summary.crtree}} to summarize results

\code{\link{predict.crtree}} for prediction
}
