% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalreg.R
\name{evalreg}
\alias{evalreg}
\title{Evaluate the performance of different regression models}
\usage{
evalreg(dataset, pred, rvar, train = "All", data_filter = "")
}
\arguments{
\item{dataset}{Dataset}

\item{pred}{Predictions or predictors}

\item{rvar}{Response variable}

\item{train}{Use data from training ("Training"), test ("Test"), both ("Both"), or all data ("All") to evaluate model evalreg}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "training == 1")}
}
\value{
A list of results
}
\description{
Evaluate the performance of different regression models
}
\details{
Evaluate different regression models based on predictions. See \url{https://radiant-rstats.github.io/docs/model/evalreg.html} for an example in Radiant
}
\examples{
data.frame(price = diamonds$price, pred1 = rnorm(3000), pred2 = diamonds$price) \%>\%
  evalreg(pred = c("pred1", "pred2"), "price") \%>\%
  str()

}
\seealso{
\code{\link{summary.evalreg}} to summarize results

\code{\link{plot.evalreg}} to plot results
}
