% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_leaderboard.R
\name{get_leaderboard}
\alias{get_leaderboard}
\title{Retrieve the leaderboard of a segment}
\usage{
get_leaderboard(stoken, id, nleaders = 10, All = FALSE)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{numeric for id of the segment}

\item{nleaders}{numeric for number of leaders to retrieve}

\item{All}{logical to retrieve all of the list}
}
\value{
Data from an API request.
}
\description{
Retrieve the leaderboard of a segment
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_leaderboard(stoken, id = 229781)
}
}
\concept{token}
