% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_processing.R
\name{undo_minmax}
\alias{undo_minmax}
\title{Reverse minmax scaling of numeric vector}
\usage{
undo_minmax(s, s_min, s_max)
}
\arguments{
\item{s}{A numeric vector or column, scaled between 0 and 1.}

\item{s_min}{A numeric value, the minimum of the unscaled vector}

\item{s_max}{A numeric value, the maximum of the unscaled vector}
}
\value{
Vector re-scaled using original parameters \code{s_min} and \code{s_max}
}
\description{
Helper function to reverse minmax scaling applied in the pre-processing step.
}
\examples{
ex_num <- runif(100,1,10)
scaled <- col_minmax(ex_num)
undo_scale <- undo_minmax(scaled, s_min = min(ex_num), s_max = max(ex_num))

# Prove two are identical
all.equal(ex_num, undo_scale)
}
\keyword{postprocessing}
