% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{frameToRules}
\alias{frameToRules}
\title{Conversion of \code{data.frame} to \code{rules} from \code{arules}}
\usage{
frameToRules(model)
}
\arguments{
\item{model}{\code{data.frame} with rules}
}
\value{
\code{arules} \code{rules} representation
}
\description{
Conversion of \code{data.frame} to \code{rules} from \code{arules}
}
\examples{
library("rCBA")
data("iris")

output <- rCBA::buildFPGrowth(iris[sample(nrow(iris), 20),], "Species", parallel=FALSE)
model <- as(output$model,"data.frame")

rules <- rCBA::frameToRules(model)
inspect(rules)

}
