% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpgrowth.R
\name{fpgrowth}
\alias{fpgrowth}
\title{FP-Growth}
\usage{
fpgrowth(train, support = 0.01, confidence = 1, maxLength = 5,
  consequent = NULL, verbose = TRUE, parallel = TRUE)
}
\arguments{
\item{train}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{support}{minimum support}

\item{confidence}{minimum confidence}

\item{maxLength}{maximum length}

\item{consequent}{filter consequent - column name with consequent/target class}

\item{verbose}{verbose indicator}

\item{parallel}{parallel indicator}
}
\description{
FP-Growth algorithm - Jiawei Han, Jian Pei, and Yiwen Yin.
Mining frequent patterns without candidate generation. SIGMOD Rec. 29, 2 (2000) <doi:10.1145/335191.335372>
}
\examples{
library("rCBA")
data("iris")

train <- sapply(iris,as.factor)
train <- data.frame(train, check.names=FALSE)
txns <- as(train,"transactions")

rules = rCBA::fpgrowth(txns, support=0.03, confidence=0.03, maxLength=2, consequent="Species",
           parallel=FALSE)

predictions <- rCBA::classification(train,rules)
table(predictions)
sum(as.character(train$Species)==as.character(predictions),na.rm=TRUE)/length(predictions)

prunedRules <- rCBA::pruning(train, rules, method="m2cba", parallel=FALSE)
predictions <- rCBA::classification(train, prunedRules)
table(predictions)
sum(as.character(train$Species)==as.character(predictions),na.rm=TRUE)/length(predictions)
}
