/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.conveyal.analysis.BackendVersion;
import com.conveyal.gtfs.model.Service;
import com.conveyal.kryo.TIntArrayListSerializer;
import com.conveyal.kryo.TIntIntHashMapSerializer;
import com.conveyal.r5.OneOriginResult;
import com.conveyal.r5.analyst.FreeFormPointSet;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.TravelTimeComputer;
import com.conveyal.r5.analyst.cluster.AnalysisWorkerTask;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.scenario.Scenario;
import com.conveyal.r5.api.ProfileResponse;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.ProfileOption;
import com.conveyal.r5.api.util.SegmentPattern;
import com.conveyal.r5.api.util.StreetEdgeInfo;
import com.conveyal.r5.api.util.StreetSegment;
import com.conveyal.r5.api.util.TransitModes;
import com.conveyal.r5.api.util.TransitSegment;
import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.kryo.KryoNetworkSerializer;
import com.conveyal.r5.point_to_point.builder.PointToPointQuery;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.streets.VertexStore;
import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.ExternalizableSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.ipea.r5r.RDataFrame;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.SerializingInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R5RCore {
    private int numberOfThreads;
    ForkJoinPool r5rThreadPool;
    private double walkSpeed;
    private double bikeSpeed;
    private int maxTransfers = 8;
    private int timeWindowSize = 60;
    private int numberOfMonteCarloDraws = 220;
    private int[] percentiles = new int[]{50};
    private TransportNetwork transportNetwork;
    private static final Logger LOG = LoggerFactory.getLogger(R5RCore.class);

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setWalkSpeed(double walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public double getBikeSpeed() {
        return this.bikeSpeed;
    }

    public void setBikeSpeed(double bikeSpeed) {
        this.bikeSpeed = bikeSpeed;
    }

    public int getTimeWindowSize() {
        return this.timeWindowSize;
    }

    public void setTimeWindowSize(int timeWindowSize) {
        this.timeWindowSize = timeWindowSize;
    }

    public int getNumberOfMonteCarloDraws() {
        return this.numberOfMonteCarloDraws;
    }

    public void setNumberOfMonteCarloDraws(int numberOfMonteCarloDraws) {
        this.numberOfMonteCarloDraws = numberOfMonteCarloDraws;
    }

    public void setPercentiles(int[] percentiles) {
        this.percentiles = percentiles;
    }

    public void setPercentiles(int percentile) {
        this.percentiles = new int[1];
        this.percentiles[0] = percentile;
    }

    public int getMaxTransfers() {
        return this.maxTransfers;
    }

    public void setMaxTransfers(int maxTransfers) {
        this.maxTransfers = maxTransfers;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        this.r5rThreadPool = new ForkJoinPool(numberOfThreads);
    }

    public void setNumberOfThreadsToMax() {
        this.r5rThreadPool = ForkJoinPool.commonPool();
        this.numberOfThreads = ForkJoinPool.commonPool().getParallelism();
    }

    public void silentMode() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger("com.conveyal.r5");
        logger.setLevel(Level.ERROR);
        logger = loggerContext.getLogger("com.conveyal.osmlib");
        logger.setLevel(Level.ERROR);
        logger = loggerContext.getLogger("com.conveyal.gtfs");
        logger.setLevel(Level.ERROR);
        logger = loggerContext.getLogger("com.conveyal.r5.profile.ExecutionTimer");
        logger.setLevel(Level.ERROR);
    }

    public void verboseMode() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger("com.conveyal.r5");
        logger.setLevel(Level.INFO);
        logger = loggerContext.getLogger("com.conveyal.osmlib");
        logger.setLevel(Level.INFO);
        logger = loggerContext.getLogger("com.conveyal.gtfs");
        logger.setLevel(Level.INFO);
        logger = loggerContext.getLogger("com.conveyal.r5.profile.ExecutionTimer");
        logger.setLevel(Level.INFO);
    }

    public void setLogMode(String mode) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger("com.conveyal.r5");
        logger.setLevel(Level.valueOf((String)mode));
    }

    public R5RCore(String dataFolder) throws FileNotFoundException {
        this(dataFolder, true);
    }

    public R5RCore(String dataFolder, boolean verbose) throws FileNotFoundException {
        if (verbose) {
            this.verboseMode();
        } else {
            this.silentMode();
        }
        this.setNumberOfThreadsToMax();
        this.walkSpeed = 1.0;
        this.bikeSpeed = 3.3f;
        File file = new File(dataFolder, "network.dat");
        if (!file.isFile()) {
            this.transportNetwork = this.createR5Network(dataFolder);
        } else if (!this.checkR5NetworkVersion(dataFolder)) {
            this.transportNetwork = this.createR5Network(dataFolder);
        }
        this.transportNetwork = this.loadR5Network(dataFolder);
        this.transportNetwork.transitLayer.buildDistanceTables(null);
    }

    private TransportNetwork loadR5Network(String dataFolder) {
        try {
            TransportNetwork tn = KryoNetworkSerializer.read((File)new File(dataFolder, "network.dat"));
            return tn;
        }
        catch (Exception e) {
            return null;
        }
    }

    private TransportNetwork createR5Network(String dataFolder) {
        File[] mapdbFiles;
        File dir = new File(dataFolder);
        for (File file : mapdbFiles = dir.listFiles((d, name) -> name.contains(".mapdb"))) {
            file.delete();
        }
        TransportNetwork tn = TransportNetwork.fromDirectory((File)new File(dataFolder));
        try {
            KryoNetworkSerializer.write((TransportNetwork)tn, (File)new File(dataFolder, "network.dat"));
            return tn;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean checkR5NetworkVersion(String dataFolder) throws FileNotFoundException {
        LOG.info("Reading transport network...");
        File file = new File(dataFolder, "network.dat");
        Input input = new Input((InputStream)new FileInputStream(file));
        Kryo kryo = R5RCore.makeKryo();
        byte[] header = new byte[KryoNetworkSerializer.HEADER.length];
        input.read(header, 0, header.length);
        if (!Arrays.equals(KryoNetworkSerializer.HEADER, header)) {
            throw new RuntimeException("Unrecognized file header. Is this an R5 Kryo network?");
        }
        String version = (String)kryo.readObject(input, String.class);
        String commit = (String)kryo.readObject(input, String.class);
        LOG.info("Loading {} file saved by R5 version {} commit {}", new Object[]{new String(header), version, commit});
        input.close();
        if (!BackendVersion.instance.version.equals(version)) {
            LOG.error(String.format("File version %s is not compatible with this R5 version %s", version, BackendVersion.instance.version));
            return false;
        }
        return true;
    }

    private static Kryo makeKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.setReferences(true);
        kryo.addDefaultSerializer(TPrimitiveHash.class, ExternalizableSerializer.class);
        kryo.register(TIntArrayList.class, (Serializer)new TIntArrayListSerializer());
        kryo.register(TIntIntHashMap.class, (Serializer)new TIntIntHashMapSerializer());
        kryo.register(BitSet.class, (Serializer)new JavaSerializer());
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new SerializingInstantiatorStrategy()));
        return kryo;
    }

    public List<LinkedHashMap<String, ArrayList<Object>>> planMultipleTrips(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration, boolean dropItineraryGeometry) throws ExecutionException, InterruptedException {
        int[] requestIndices = new int[fromIds.length];
        for (int i = 0; i < fromIds.length; ++i) {
            requestIndices[i] = i;
        }
        return (List)((ForkJoinTask)this.r5rThreadPool.submit(() -> Arrays.stream(requestIndices).parallel().mapToObj(index -> {
            LinkedHashMap<String, ArrayList<Object>> results = null;
            try {
                results = this.planSingleTrip(fromIds[index], fromLats[index], fromLons[index], toIds[index], toLats[index], toLons[index], directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxTripDuration, dropItineraryGeometry);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return results;
        }).collect(Collectors.toList()))).get();
    }

    public LinkedHashMap<String, ArrayList<Object>> planSingleTrip(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration, boolean dropItineraryGeometry) throws ParseException {
        int secondsFromMidnight;
        RegionalTask request = new RegionalTask();
        request.zoneId = this.transportNetwork.getTimeZone();
        request.fromLat = fromLat;
        request.fromLon = fromLon;
        request.toLat = toLat;
        request.toLon = toLon;
        request.streetTime = maxTripDuration;
        request.maxWalkTime = maxWalkTime;
        request.maxBikeTime = maxTripDuration;
        request.maxCarTime = maxTripDuration;
        request.walkSpeed = (float)this.walkSpeed;
        request.bikeSpeed = (float)this.bikeSpeed;
        request.maxTripDurationMinutes = maxTripDuration;
        request.computePaths = true;
        request.computeTravelTimeBreakdown = true;
        request.maxRides = this.maxTransfers;
        request.directModes = EnumSet.noneOf(LegMode.class);
        String[] modes = directModes.split(";");
        if (!directModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.directModes.add(LegMode.valueOf((String)mode));
            }
        }
        request.transitModes = EnumSet.noneOf(TransitModes.class);
        modes = transitModes.split(";");
        if (!transitModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.transitModes.add(TransitModes.valueOf((String)mode));
            }
        }
        request.accessModes = EnumSet.noneOf(LegMode.class);
        modes = accessModes.split(";");
        if (!accessModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.accessModes.add(LegMode.valueOf((String)mode));
            }
        }
        request.egressModes = EnumSet.noneOf(LegMode.class);
        modes = egressModes.split(";");
        if (!egressModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.egressModes.add(LegMode.valueOf((String)mode));
            }
        }
        request.date = LocalDate.parse(date);
        request.fromTime = secondsFromMidnight = this.getSecondsFromMidnight(departureTime);
        request.toTime = secondsFromMidnight + 60;
        request.monteCarloDraws = 1;
        PointToPointQuery query = new PointToPointQuery(this.transportNetwork);
        ProfileResponse response = query.getPlan((ProfileRequest)request);
        if (!response.getOptions().isEmpty()) {
            return this.buildPathOptionsTable(fromId, fromLat, fromLon, toId, toLat, toLon, maxWalkTime, maxTripDuration, dropItineraryGeometry, response.getOptions());
        }
        return null;
    }

    private int getSecondsFromMidnight(String departureTime) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date reference = dateFormat.parse("00:00:00");
        Date date = dateFormat.parse(departureTime);
        return (int)((date.getTime() - reference.getTime()) / 1000L);
    }

    private LinkedHashMap<String, ArrayList<Object>> buildPathOptionsTable(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, int maxWalkTime, int maxTripDuration, boolean dropItineraryGeometry, List<ProfileOption> pathOptions) {
        RDataFrame pathOptionsTable = new RDataFrame();
        pathOptionsTable.addStringColumn("fromId", fromId);
        pathOptionsTable.addDoubleColumn("fromLat", fromLat);
        pathOptionsTable.addDoubleColumn("fromLon", fromLon);
        pathOptionsTable.addStringColumn("toId", toId);
        pathOptionsTable.addDoubleColumn("toLat", toLat);
        pathOptionsTable.addDoubleColumn("toLon", toLon);
        pathOptionsTable.addIntegerColumn("option", 0);
        pathOptionsTable.addIntegerColumn("segment", 0);
        pathOptionsTable.addStringColumn("mode", "");
        pathOptionsTable.addIntegerColumn("total_duration", 0);
        pathOptionsTable.addDoubleColumn("segment_duration", 0.0);
        pathOptionsTable.addDoubleColumn("wait", 0.0);
        pathOptionsTable.addIntegerColumn("distance", 0);
        pathOptionsTable.addStringColumn("route", "");
        if (!dropItineraryGeometry) {
            pathOptionsTable.addStringColumn("geometry", "");
        }
        int optionIndex = 0;
        for (ProfileOption option : pathOptions) {
            if (option.stats.avg > maxTripDuration * 60) continue;
            if (option.transit == null) {
                if (option.access == null) continue;
                for (StreetSegment segment : option.access) {
                    if (segment.mode == LegMode.WALK & segment.duration / 60 > maxWalkTime) continue;
                    pathOptionsTable.append();
                    pathOptionsTable.set("option", ++optionIndex);
                    pathOptionsTable.set("segment", 1);
                    pathOptionsTable.set("mode", segment.mode.toString());
                    pathOptionsTable.set("segment_duration", (double)segment.duration / 60.0);
                    pathOptionsTable.set("total_duration", (double)option.stats.avg / 60.0);
                    int dist = this.calculateSegmentLength(segment);
                    pathOptionsTable.set("distance", dist / 1000);
                    if (dropItineraryGeometry) continue;
                    pathOptionsTable.set("geometry", segment.geometry.toString());
                }
                continue;
            }
            ++optionIndex;
            int segmentIndex = 0;
            if (option.access != null) {
                for (StreetSegment segment : option.access) {
                    pathOptionsTable.append();
                    pathOptionsTable.set("option", optionIndex);
                    pathOptionsTable.set("segment", ++segmentIndex);
                    pathOptionsTable.set("mode", segment.mode.toString());
                    pathOptionsTable.set("segment_duration", (double)segment.duration / 60.0);
                    pathOptionsTable.set("total_duration", (double)option.stats.avg / 60.0);
                    int dist = this.calculateSegmentLength(segment);
                    pathOptionsTable.set("distance", dist / 1000);
                    if (dropItineraryGeometry) continue;
                    pathOptionsTable.set("geometry", segment.geometry.toString());
                }
            }
            for (TransitSegment transit : option.transit) {
                SegmentPattern pattern = (SegmentPattern)transit.segmentPatterns.get(0);
                pathOptionsTable.append();
                TripPattern tripPattern = (TripPattern)this.transportNetwork.transitLayer.tripPatterns.get(pattern.patternIdx);
                StringBuilder geometry = new StringBuilder();
                int accDistance = this.buildTransitGeometryAndCalculateDistance(pattern, tripPattern, geometry);
                pathOptionsTable.set("option", optionIndex);
                pathOptionsTable.set("segment", ++segmentIndex);
                pathOptionsTable.set("mode", transit.mode.toString());
                pathOptionsTable.set("segment_duration", (double)transit.rideStats.avg / 60.0);
                pathOptionsTable.set("total_duration", (double)option.stats.avg / 60.0);
                pathOptionsTable.set("distance", accDistance);
                pathOptionsTable.set("route", tripPattern.routeId);
                pathOptionsTable.set("wait", (double)transit.waitStats.avg / 60.0);
                if (!dropItineraryGeometry) {
                    pathOptionsTable.set("geometry", geometry.toString());
                }
                if (transit.middle == null) continue;
                pathOptionsTable.append();
                pathOptionsTable.set("option", optionIndex);
                pathOptionsTable.set("segment", ++segmentIndex);
                pathOptionsTable.set("mode", transit.middle.mode.toString());
                pathOptionsTable.set("segment_duration", (double)transit.middle.duration / 60.0);
                pathOptionsTable.set("total_duration", (double)option.stats.avg / 60.0);
                int dist = this.calculateSegmentLength(transit.middle);
                pathOptionsTable.set("distance", dist / 1000);
                if (dropItineraryGeometry) continue;
                pathOptionsTable.set("geometry", transit.middle.geometry.toString());
            }
            if (option.egress == null) continue;
            for (StreetSegment segment : option.egress) {
                pathOptionsTable.append();
                pathOptionsTable.set("option", optionIndex);
                pathOptionsTable.set("segment", ++segmentIndex);
                pathOptionsTable.set("mode", segment.mode.toString());
                pathOptionsTable.set("segment_duration", (double)segment.duration / 60.0);
                pathOptionsTable.set("total_duration", (double)option.stats.avg / 60.0);
                int dist = this.calculateSegmentLength(segment);
                pathOptionsTable.set("distance", dist / 1000);
                if (dropItineraryGeometry) continue;
                pathOptionsTable.set("geometry", segment.geometry.toString());
            }
        }
        if (pathOptionsTable.nRow() > 0) {
            return pathOptionsTable.getDataFrame();
        }
        return null;
    }

    private int buildTransitGeometryAndCalculateDistance(SegmentPattern segmentPattern, TripPattern tripPattern, StringBuilder geometry) {
        Coordinate previousCoordinate = new Coordinate(0.0, 0.0);
        double accDistance = 0.0;
        if (tripPattern.shape != null) {
            List shapeSegments = tripPattern.getHopGeometries(this.transportNetwork.transitLayer);
            int firstStop = segmentPattern.fromIndex;
            int lastStop = segmentPattern.toIndex;
            for (int i = firstStop; i < lastStop; ++i) {
                for (Coordinate coordinate : ((LineString)shapeSegments.get(i)).getCoordinates()) {
                    if (geometry.toString().equals("")) {
                        geometry.append("LINESTRING (").append(coordinate.x).append(" ").append(coordinate.y);
                    } else {
                        geometry.append(", ").append(coordinate.x).append(" ").append(coordinate.y);
                        accDistance += GeometryUtils.distance((double)previousCoordinate.y, (double)previousCoordinate.x, (double)coordinate.y, (double)coordinate.x);
                    }
                    previousCoordinate.x = coordinate.x;
                    previousCoordinate.y = coordinate.y;
                }
            }
            geometry.append(")");
        } else {
            for (int stop = segmentPattern.fromIndex; stop <= segmentPattern.toIndex; ++stop) {
                int stopIdx = tripPattern.stops[stop];
                Coordinate coordinate = this.transportNetwork.transitLayer.getCoordinateForStopFixed(stopIdx);
                coordinate.x /= 1.0E7;
                coordinate.y /= 1.0E7;
                if (geometry.toString().equals("")) {
                    geometry.append("LINESTRING (").append(coordinate.x).append(" ").append(coordinate.y);
                } else {
                    geometry.append(", ").append(coordinate.x).append(" ").append(coordinate.y);
                    accDistance += GeometryUtils.distance((double)previousCoordinate.y, (double)previousCoordinate.x, (double)coordinate.y, (double)coordinate.x);
                }
                previousCoordinate.x = coordinate.x;
                previousCoordinate.y = coordinate.y;
            }
            geometry.append(")");
        }
        return (int)accDistance;
    }

    private int calculateSegmentLength(StreetSegment segment) {
        int sum = 0;
        for (StreetEdgeInfo streetEdgeInfo : segment.streetEdges) {
            sum += streetEdgeInfo.distance;
        }
        return sum;
    }

    public List<LinkedHashMap<String, ArrayList<Object>>> travelTimeMatrixParallel(String fromId, double fromLat, double fromLon, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        return this.travelTimeMatrixParallel(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxTripDuration);
    }

    public List<LinkedHashMap<String, ArrayList<Object>>> travelTimeMatrixParallel(String[] fromIds, double[] fromLats, double[] fromLons, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.travelTimeMatrixParallel(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxTripDuration);
    }

    public List<LinkedHashMap<String, ArrayList<Object>>> travelTimeMatrixParallel(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.travelTimeMatrixParallel(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxTripDuration);
    }

    public List<LinkedHashMap<String, ArrayList<Object>>> travelTimeMatrixParallel(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        int[] originIndices = new int[fromIds.length];
        for (int i = 0; i < fromIds.length; ++i) {
            originIndices[i] = i;
        }
        FreeFormPointSet destinationPoints = new FreeFormPointSet(toIds.length);
        for (int i = 0; i < toIds.length; ++i) {
            destinationPoints.setId(i, toIds[i]);
            destinationPoints.setLat(i, toLats[i]);
            destinationPoints.setLon(i, toLons[i]);
            destinationPoints.setCount(i, 1.0);
        }
        String[] modes = accessModes.split(";");
        if (!accessModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                this.transportNetwork.linkageCache.getLinkage((PointSet)destinationPoints, this.transportNetwork.streetLayer, StreetMode.valueOf((String)mode));
            }
        }
        FreeFormPointSet finalDestinationPoints = destinationPoints;
        List returnList = (List)((ForkJoinTask)this.r5rThreadPool.submit(() -> Arrays.stream(originIndices).parallel().mapToObj(index -> {
            LinkedHashMap<String, ArrayList<Object>> results = null;
            try {
                results = this.travelTimesFromOrigin(fromIds[index], fromLats[index], fromLons[index], toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxTripDuration, finalDestinationPoints);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return results;
        }).collect(Collectors.toList()))).get();
        return returnList;
    }

    private LinkedHashMap<String, ArrayList<Object>> travelTimesFromOrigin(String fromId, double fromLat, double fromLon, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxTripDuration, FreeFormPointSet destinationPoints) throws ParseException {
        int secondsFromMidnight;
        RegionalTask request = new RegionalTask();
        request.scenario = new Scenario();
        request.scenarioId = request.scenario.id = "id";
        request.zoneId = this.transportNetwork.getTimeZone();
        request.fromLat = fromLat;
        request.fromLon = fromLon;
        request.walkSpeed = (float)this.walkSpeed;
        request.bikeSpeed = (float)this.bikeSpeed;
        request.streetTime = maxTripDuration;
        request.maxWalkTime = maxWalkTime;
        request.maxBikeTime = maxTripDuration;
        request.maxCarTime = maxTripDuration;
        request.maxTripDurationMinutes = maxTripDuration;
        request.makeTauiSite = false;
        request.computePaths = false;
        request.computeTravelTimeBreakdown = false;
        request.recordTimes = true;
        request.maxRides = this.maxTransfers;
        request.directModes = EnumSet.noneOf(LegMode.class);
        String[] modes = directModes.split(";");
        if (!directModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.directModes.add(LegMode.valueOf((String)mode));
            }
        }
        request.transitModes = EnumSet.noneOf(TransitModes.class);
        modes = transitModes.split(";");
        if (!transitModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.transitModes.add(TransitModes.valueOf((String)mode));
            }
        }
        request.accessModes = EnumSet.noneOf(LegMode.class);
        modes = accessModes.split(";");
        if (!accessModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.accessModes.add(LegMode.valueOf((String)mode));
            }
        }
        request.egressModes = EnumSet.noneOf(LegMode.class);
        modes = egressModes.split(";");
        if (!egressModes.equals("") & modes.length > 0) {
            for (String mode : modes) {
                request.egressModes.add(LegMode.valueOf((String)mode));
            }
        }
        request.date = LocalDate.parse(date);
        request.fromTime = secondsFromMidnight = this.getSecondsFromMidnight(departureTime);
        request.toTime = secondsFromMidnight + this.timeWindowSize * 60;
        request.monteCarloDraws = this.numberOfMonteCarloDraws;
        request.destinationPointSets = new PointSet[1];
        request.destinationPointSets[0] = destinationPoints;
        request.percentiles = this.percentiles;
        TravelTimeComputer computer = new TravelTimeComputer((AnalysisWorkerTask)request, this.transportNetwork);
        OneOriginResult travelTimeResults = computer.computeTravelTimes();
        RDataFrame travelTimesTable = new RDataFrame();
        travelTimesTable.addStringColumn("fromId", fromId);
        travelTimesTable.addStringColumn("toId", "");
        if (this.percentiles.length == 1) {
            travelTimesTable.addIntegerColumn("travel_time", Integer.MAX_VALUE);
        } else {
            for (int p : this.percentiles) {
                String ps = String.format("%03d", p);
                travelTimesTable.addIntegerColumn("travel_time_p" + ps, Integer.MAX_VALUE);
            }
        }
        for (int i = 0; i < travelTimeResults.travelTimes.nPoints; ++i) {
            if (travelTimeResults.travelTimes.getValues()[0][i] > maxTripDuration) continue;
            travelTimesTable.append();
            travelTimesTable.set("toId", toIds[i]);
            if (this.percentiles.length == 1) {
                travelTimesTable.set("travel_time", travelTimeResults.travelTimes.getValues()[0][i]);
                continue;
            }
            for (int p = 0; p < this.percentiles.length; ++p) {
                int tt = travelTimeResults.travelTimes.getValues()[p][i];
                String ps = String.format("%03d", this.percentiles[p]);
                if (tt >= maxTripDuration) continue;
                travelTimesTable.set("travel_time_p" + ps, tt);
            }
        }
        if (travelTimesTable.nRow() > 0) {
            return travelTimesTable.getDataFrame();
        }
        return null;
    }

    public List<Object> getStreetNetwork() {
        ArrayList<Integer> indexCol = new ArrayList<Integer>();
        ArrayList<Double> latCol = new ArrayList<Double>();
        ArrayList<Double> lonCol = new ArrayList<Double>();
        ArrayList<Boolean> parkAndRideCol = new ArrayList<Boolean>();
        ArrayList<Boolean> bikeSharingCol = new ArrayList<Boolean>();
        LinkedHashMap<String, ArrayList<Serializable>> verticesTable = new LinkedHashMap<String, ArrayList<Serializable>>();
        verticesTable.put("index", indexCol);
        verticesTable.put("lat", latCol);
        verticesTable.put("lon", lonCol);
        verticesTable.put("park_and_ride", parkAndRideCol);
        verticesTable.put("bike_sharing", bikeSharingCol);
        VertexStore vertices = this.transportNetwork.streetLayer.vertexStore;
        VertexStore.Vertex vertexCursor = vertices.getCursor();
        while (vertexCursor.advance()) {
            indexCol.add(vertexCursor.index);
            latCol.add(vertexCursor.getLat());
            lonCol.add(vertexCursor.getLon());
            parkAndRideCol.add(vertexCursor.getFlag(VertexStore.VertexFlag.PARK_AND_RIDE));
            bikeSharingCol.add(vertexCursor.getFlag(VertexStore.VertexFlag.BIKE_SHARING));
        }
        ArrayList<Integer> fromVertexCol = new ArrayList<Integer>();
        ArrayList<Integer> toVertexCol = new ArrayList<Integer>();
        ArrayList<Double> lengthCol = new ArrayList<Double>();
        ArrayList<Boolean> walkCol = new ArrayList<Boolean>();
        ArrayList<Boolean> bicycleCol = new ArrayList<Boolean>();
        ArrayList<Boolean> carCol = new ArrayList<Boolean>();
        ArrayList<String> geometryCol = new ArrayList<String>();
        LinkedHashMap<String, ArrayList<Object>> edgesTable = new LinkedHashMap<String, ArrayList<Object>>();
        edgesTable.put("from_vertex", fromVertexCol);
        edgesTable.put("to_vertex", toVertexCol);
        edgesTable.put("length", lengthCol);
        edgesTable.put("walk", walkCol);
        edgesTable.put("bicycle", bicycleCol);
        edgesTable.put("car", carCol);
        edgesTable.put("geometry", geometryCol);
        EdgeStore edges = this.transportNetwork.streetLayer.edgeStore;
        EdgeStore.Edge edgeCursor = edges.getCursor();
        while (edgeCursor.advance()) {
            fromVertexCol.add(edgeCursor.getFromVertex());
            toVertexCol.add(edgeCursor.getToVertex());
            lengthCol.add(edgeCursor.getLengthM());
            walkCol.add(edgeCursor.allowsStreetMode(StreetMode.WALK));
            bicycleCol.add(edgeCursor.allowsStreetMode(StreetMode.BICYCLE));
            carCol.add(edgeCursor.allowsStreetMode(StreetMode.CAR));
            geometryCol.add(edgeCursor.getGeometry().toString());
        }
        ArrayList<Object> transportNetworkList = new ArrayList<Object>();
        transportNetworkList.add(verticesTable);
        transportNetworkList.add(edgesTable);
        return transportNetworkList;
    }

    public List<Object> getTransitNetwork() {
        RDataFrame routesTable = new RDataFrame();
        routesTable.addStringColumn("agency_id", "");
        routesTable.addStringColumn("agency_name", "");
        routesTable.addStringColumn("route_id", "");
        routesTable.addStringColumn("long_name", "");
        routesTable.addStringColumn("short_name", "");
        routesTable.addStringColumn("mode", "");
        routesTable.addStringColumn("geometry", "");
        for (TripPattern pattern : this.transportNetwork.transitLayer.tripPatterns) {
            RouteInfo route = (RouteInfo)this.transportNetwork.transitLayer.routes.get(pattern.routeIndex);
            routesTable.append();
            routesTable.set("agency_id", route.agency_id);
            routesTable.set("agency_name", route.agency_name);
            routesTable.set("route_id", route.route_id);
            routesTable.set("long_name", route.route_long_name);
            routesTable.set("short_name", route.route_short_name);
            routesTable.set("mode", TransitLayer.getTransitModes((int)route.route_type).toString());
            if (pattern.shape != null) {
                routesTable.set("geometry", pattern.shape.toString());
                continue;
            }
            StringBuilder geometry = new StringBuilder();
            for (int stopIndex : pattern.stops) {
                Coordinate coordinate = this.transportNetwork.transitLayer.getCoordinateForStopFixed(stopIndex);
                if (coordinate == null) continue;
                coordinate.x /= 1.0E7;
                coordinate.y /= 1.0E7;
                if (geometry.toString().equals("")) {
                    geometry.append("LINESTRING (").append(coordinate.x).append(" ").append(coordinate.y);
                    continue;
                }
                geometry.append(", ").append(coordinate.x).append(" ").append(coordinate.y);
            }
            if (!geometry.toString().equals("")) {
                geometry.append(")");
            }
            routesTable.set("geometry", geometry.toString());
        }
        RDataFrame stopsTable = new RDataFrame();
        stopsTable.addIntegerColumn("stop_index", -1);
        stopsTable.addStringColumn("stop_id", "");
        stopsTable.addStringColumn("stop_name", "");
        stopsTable.addDoubleColumn("lat", -1.0);
        stopsTable.addDoubleColumn("lon", -1.0);
        stopsTable.addBooleanColumn("linked_to_street", false);
        LOG.info("Getting public transport stops from Transport Network");
        LOG.info("{} stops were found in the network", (Object)this.transportNetwork.transitLayer.getStopCount());
        for (int stopIndex = 0; stopIndex < this.transportNetwork.transitLayer.getStopCount(); ++stopIndex) {
            Coordinate coordinate;
            LOG.info("Stop #{}", (Object)stopIndex);
            LOG.info("Stop id: {}", this.transportNetwork.transitLayer.stopIdForIndex.get(stopIndex));
            stopsTable.append();
            stopsTable.set("stop_index", stopIndex);
            stopsTable.set("stop_id", (String)this.transportNetwork.transitLayer.stopIdForIndex.get(stopIndex));
            if (this.transportNetwork.transitLayer.stopNames != null) {
                LOG.info("Stop name: {}", this.transportNetwork.transitLayer.stopNames.get(stopIndex));
                stopsTable.set("stop_name", (String)this.transportNetwork.transitLayer.stopNames.get(stopIndex));
            }
            if ((coordinate = this.transportNetwork.transitLayer.getCoordinateForStopFixed(stopIndex)) != null) {
                Double lat = coordinate.y / 1.0E7;
                Double lon = coordinate.x / 1.0E7;
                stopsTable.set("lat", lat);
                stopsTable.set("lon", lon);
            }
            boolean linkedToStreet = this.transportNetwork.transitLayer.streetVertexForStop.get(stopIndex) != -1;
            stopsTable.set("linked_to_street", linkedToStreet);
        }
        ArrayList<Object> transportNetworkList = new ArrayList<Object>();
        transportNetworkList.add(routesTable.getDataFrame());
        transportNetworkList.add(stopsTable.getDataFrame());
        return transportNetworkList;
    }

    public LinkedHashMap<String, ArrayList<Object>> getTransitServicesByDate(String date) {
        RDataFrame servicesTable = new RDataFrame();
        servicesTable.addStringColumn("service_id", "");
        servicesTable.addStringColumn("start_date", "");
        servicesTable.addStringColumn("end_date", "");
        servicesTable.addBooleanColumn("active_on_date", false);
        for (Service service : this.transportNetwork.transitLayer.services) {
            servicesTable.append();
            servicesTable.set("service_id", service.service_id);
            if (service.calendar != null) {
                servicesTable.set("start_date", String.valueOf(service.calendar.start_date));
                servicesTable.set("end_date", String.valueOf(service.calendar.end_date));
            }
            servicesTable.set("active_on_date", service.activeOn(LocalDate.parse(date)));
        }
        return servicesTable.getDataFrame();
    }
}

