% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_encode_figure.R
\name{rtf_encode_figure}
\alias{rtf_encode_figure}
\title{Render Figure to RTF Encoding}
\usage{
rtf_encode_figure(tbl)
}
\arguments{
\item{tbl}{A data frame for table or a list of binary string for figure.}
}
\description{
Render Figure to RTF Encoding
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Collect footnote attributes from \code{tbl} object.
   \item Define page, margin, header, footnote, source and new_page in RTF syntax.
   \item Define page height and width in RTF syntax.
   \item Initiate RTF using \code{as_rtf_init()} and \code{as_rtf_font()}.
   \item Get page title display location ("all", "first", "last") from arg input and display it in page accordingly.
   \item Get page footnote display location ("all", "first", "last") from arg input and display it in page accordingly.
   \item Get page source display location ("all", "first", "last") from arg input and display it in page accordingly.
   \item Translate all \code{tbl} attributes into RTF syntax.
   \item Combine all components into a single RTF code string.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

