/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Header;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.PMMLUtil;

public class PMMLEncoder {
    private Map<FieldName, DataField> dataFields = new LinkedHashMap<FieldName, DataField>();
    private Map<FieldName, DerivedField> derivedFields = new LinkedHashMap<FieldName, DerivedField>();
    private Map<String, DefineFunction> defineFunctions = new LinkedHashMap<String, DefineFunction>();

    public PMML encodePMML() {
        if (!Collections.disjoint(this.dataFields.keySet(), this.derivedFields.keySet())) {
            throw new IllegalStateException();
        }
        ArrayList<DataField> dataFields = new ArrayList<DataField>(this.dataFields.values());
        DataDictionary dataDictionary = new DataDictionary();
        if (dataFields.size() > 0) {
            dataDictionary.getDataFields().addAll(dataFields);
        }
        ArrayList<DerivedField> derivedFields = new ArrayList<DerivedField>(this.derivedFields.values());
        ArrayList<DefineFunction> defineFunctions = new ArrayList<DefineFunction>(this.defineFunctions.values());
        TransformationDictionary transformationDictionary = null;
        if (derivedFields.size() > 0 || defineFunctions.size() > 0) {
            transformationDictionary = new TransformationDictionary();
            if (derivedFields.size() > 0) {
                transformationDictionary.getDerivedFields().addAll(derivedFields);
            }
            if (defineFunctions.size() > 0) {
                transformationDictionary.getDefineFunctions().addAll(defineFunctions);
            }
        }
        Header header = this.encodeHeader();
        PMML pmml = new PMML("4.3", header, dataDictionary).setTransformationDictionary(transformationDictionary);
        return pmml;
    }

    public Header encodeHeader() {
        return PMMLUtil.createHeader(this.getClass());
    }

    public DataField getDataField(FieldName name) {
        return this.dataFields.get(name);
    }

    public void addDataField(DataField dataField) {
        FieldName name = this.checkName((Field<?>)dataField);
        this.dataFields.put(name, dataField);
    }

    public DataField createDataField(FieldName name, OpType opType, DataType dataType) {
        return this.createDataField(name, opType, dataType, null);
    }

    public DataField createDataField(FieldName name, OpType opType, DataType dataType, List<?> values) {
        DataField dataField = new DataField(name, opType, dataType);
        if (values != null && values.size() > 0) {
            PMMLUtil.addValues(dataField, values);
        }
        this.addDataField(dataField);
        return dataField;
    }

    public DataField removeDataField(FieldName name) {
        DataField dataField = this.dataFields.remove(name);
        if (dataField == null) {
            throw new IllegalArgumentException("Field " + name.getValue() + " is undefined");
        }
        return dataField;
    }

    public DerivedField ensureDerivedField(FieldName name, OpType opType, DataType dataType, Supplier<? extends Expression> expressionSupplier) {
        DerivedField derivedField = this.getDerivedField(name);
        if (derivedField == null) {
            Expression expression = expressionSupplier.get();
            derivedField = this.createDerivedField(name, opType, dataType, expression);
        }
        return derivedField;
    }

    public DerivedField getDerivedField(FieldName name) {
        return this.derivedFields.get(name);
    }

    public void addDerivedField(DerivedField derivedField) {
        FieldName name = this.checkName((Field<?>)derivedField);
        this.derivedFields.put(name, derivedField);
    }

    public DerivedField createDerivedField(FieldName name, OpType opType, DataType dataType, Expression expression) {
        DerivedField derivedField = new DerivedField(name, opType, dataType, expression);
        this.addDerivedField(derivedField);
        return derivedField;
    }

    public DerivedOutputField createDerivedField(Output output, OutputField outputField) {
        DerivedOutputField derivedField = new DerivedOutputField(output, outputField);
        this.addDerivedField(derivedField);
        return derivedField;
    }

    public DerivedField removeDerivedField(FieldName name) {
        DerivedField derivedField = this.derivedFields.remove(name);
        if (derivedField == null) {
            throw new IllegalArgumentException("Field " + name.getValue() + " is undefined");
        }
        return derivedField;
    }

    public Field<?> getField(FieldName name) {
        DataField dataField = this.getDataField(name);
        DerivedField derivedField = this.getDerivedField(name);
        if (dataField != null && derivedField != null) {
            throw new IllegalStateException();
        }
        if (dataField != null && derivedField == null) {
            return dataField;
        }
        if (dataField == null && derivedField != null) {
            return derivedField;
        }
        throw new IllegalArgumentException("Field " + name.getValue() + " is undefined");
    }

    public Field<?> toContinuous(FieldName name) {
        Field<?> field = this.getField(name);
        DataType dataType = field.getDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + name.getValue() + " has data type " + dataType);
            }
        }
        field.setOpType(OpType.CONTINUOUS);
        return field;
    }

    public Field<?> toCategorical(FieldName name, List<?> values) {
        Field<?> field = this.getField(name);
        if (field instanceof DataField) {
            DataField dataField = (DataField)field;
            List<?> existingValues = PMMLUtil.getValues(dataField);
            if (existingValues != null && existingValues.size() > 0) {
                if (!existingValues.equals(values)) {
                    throw new IllegalArgumentException("Field " + name.getValue() + " has valid values " + existingValues);
                }
            } else {
                PMMLUtil.addValues(dataField, values);
            }
        }
        field.setOpType(OpType.CATEGORICAL);
        return field;
    }

    public DefineFunction getDefineFunction(String name) {
        return this.defineFunctions.get(name);
    }

    public void addDefineFunction(DefineFunction defineFunction) {
        String name = defineFunction.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.defineFunctions.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        this.defineFunctions.put(name, defineFunction);
    }

    public Map<FieldName, DataField> getDataFields() {
        return this.dataFields;
    }

    public Map<FieldName, DerivedField> getDerivedFields() {
        return this.derivedFields;
    }

    public Map<String, DefineFunction> getDefineFunctions() {
        return this.defineFunctions;
    }

    private FieldName checkName(Field<?> field) {
        FieldName name = field.getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataFields.containsKey(name) || this.derivedFields.containsKey(name)) {
            throw new IllegalArgumentException("Field " + name.getValue() + " is already defined");
        }
        return name;
    }
}

