% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{predict.qgcompfit}
\alias{predict.qgcompfit}
\title{predict.qgcompfit: default prediction method for a qgcompfit object}
\usage{
\method{predict}{qgcompfit}(object, expnms = NULL, newdata = NULL,
  type = "response", ...)
}
\arguments{
\item{object}{"qgcompfit" object from `qgcomp.noboot` or  `qgcomp.boot` functions}

\item{expnms}{character vector of exposures of interest}

\item{newdata}{(optional) new set of data with all predictors from "qgcompfit" object}

\item{type}{(from predict.glm) the type of prediction required. The default 
is on the scale of the linear predictors; the alternative "response" is on 
the scale of the response  variable. Thus for a default binomial model the 
default predictions are of log-odds (probabilities on logit scale) and 
type = "response" gives the predicted probabilities. The "terms" option 
returns a matrix giving the fitted values of each term in the model formula 
on the linear predictor scale.}

\item{...}{arguments to predict.glm}
}
\description{
get predicted values from a qgcompfit object, or make predictions
in a new set of data based on the qgcomfit object. Note that when making predictions
from an object from qgcomp.boot, the predictions are made from the g-computation
model rather than the marginal structural model. Predictions from the marginal
structural model can be obtained via \code{\link[qgcomp]{msm.predict}}
}
\examples{
set.seed(50)
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50), z=runif(50))
obj1 <- qgcomp.noboot(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2)
obj2 <- qgcomp.boot(y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, B=10, seed=125)
set.seed(52)
dat2 <- data.frame(y=runif(50), x1=runif(50), x2=runif(50), z=runif(50))
summary(predict(obj1, expnms = c('x1', 'x2'), newdata=dat2))
summary(predict(obj2, expnms = c('x1', 'x2'), newdata=dat2))
}
