/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.wizard;

import com.qarks.util.ui.help.HelpButton;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class WizardDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private JButton next;
    private JButton previous;
    private JButton help;
    private JPanel pagePanel;
    private JLabel pageTitleLabel;
    private WizardPage currentPage;
    private JPanel pageTitlePanel;
    private JPanel toolbar;
    private boolean cancelled = true;

    public WizardDialog(Window window, String string) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.init(null);
    }

    public WizardDialog(Window window, String string, String string2) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.init(string2);
    }

    private void init(String string) {
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        container.add(jPanel);
        this.toolbar = new JPanel(new FlowLayout(2, 5, 10)){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Dimension dimension = WizardDialog.this.toolbar.getSize();
                graphics.setColor(Color.lightGray);
                graphics.drawLine(0, 0, dimension.width - 1, 0);
                graphics.setColor(Color.white);
                graphics.drawLine(0, 1, dimension.width - 1, 1);
            }
        };
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.next = new JButton(ResourceManager.getString((Object)ResourceKey.NEXT));
        this.previous = new JButton(ResourceManager.getString((Object)ResourceKey.PREVIOUS));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.next.addActionListener(this);
        this.previous.addActionListener(this);
        this.toolbar.add(this.previous);
        this.toolbar.add(this.next);
        this.toolbar.add(this.ok);
        this.toolbar.add(this.cancel);
        if (string != null) {
            this.help = new HelpButton(string);
            this.toolbar.add(this.help);
        }
        this.pagePanel = new JPanel(new GridLayout(1, 1));
        this.pageTitlePanel = new JPanel(new BorderLayout(5, 5)){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = 50;
                return dimension;
            }

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Dimension dimension = WizardDialog.this.pageTitlePanel.getSize();
                graphics.setColor(Color.lightGray);
                graphics.drawLine(0, dimension.height - 2, dimension.width - 1, dimension.height - 2);
                graphics.setColor(Color.white);
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            }
        };
        this.pageTitlePanel.setOpaque(true);
        this.pageTitlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.pageTitleLabel = new JLabel("");
        this.pageTitleLabel.setOpaque(true);
        this.pageTitleLabel.setBackground(Color.white);
        this.pageTitlePanel.setBackground(Color.white);
        this.pageTitlePanel.add((Component)this.pageTitleLabel, "West");
        jPanel.add((Component)this.pageTitlePanel, "North");
        jPanel.add((Component)this.pagePanel, "Center");
        jPanel.add((Component)this.toolbar, "South");
    }

    public void setCurrentPage(WizardPage wizardPage) {
        this.currentPage = wizardPage;
        this.updatePage();
    }

    void updateWizard(boolean bl) {
        if (this.currentPage != null) {
            this.next.setEnabled(bl && this.currentPage.getNextPage() != null);
            this.previous.setEnabled(this.currentPage.getPreviousPage() != null);
            this.ok.setEnabled(this.currentPage.canGoToNext() && this.currentPage.getNextPage() == null);
        }
    }

    private void updatePage() {
        if (this.currentPage != null) {
            this.pagePanel.removeAll();
            this.pagePanel.add(this.currentPage);
            this.next.setEnabled(this.currentPage.canGoToNext() && this.currentPage.getNextPage() != null);
            this.previous.setEnabled(this.currentPage.getPreviousPage() != null);
            this.ok.setEnabled(this.currentPage.canGoToNext() && this.currentPage.getNextPage() == null);
            this.pageTitleLabel.setText(this.currentPage.getTitle());
            this.currentPage.invalidate();
            this.pagePanel.validate();
            this.repaint();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.pageTitleLabel.setFont(this.getFont().deriveFont(1));
    }

    protected boolean canFinish() {
        return true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.next) {
            this.currentPage.onGoingNextPage();
            this.currentPage = this.currentPage.getNextPage();
            this.updatePage();
        } else if (object == this.previous) {
            this.currentPage = this.currentPage.getPreviousPage();
            this.updatePage();
        } else if (object == this.ok) {
            this.currentPage.onGoingNextPage();
            if (this.canFinish()) {
                this.cancelled = false;
                this.dispose();
            }
        } else if (object == this.cancel) {
            this.dispose();
        }
    }
}

