/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.swing.file_chooser.FileSystemParserUtility;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileTreeNode
extends DefaultMutableTreeNode {
    private boolean mIsLeaf = false;
    private String mName = "";
    private File mFile = null;
    private Icon mIcon = null;
    private FileView mFileView = null;

    public FileTreeNode(File[] fileArray) {
        super(fileArray);
    }

    public FileTreeNode(FileView fileView, File file) {
        super(file);
        this.mFile = file;
        this.mFileView = fileView;
        this.mIcon = this.mFileView.getIcon(this.mFile);
        this.mName = this.mFileView.getName(this.mFile);
        if (this.mIcon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)this.mIcon;
        }
    }

    public File getFile() {
        Object object = super.getUserObject();
        if (object instanceof File) {
            return (File)object;
        }
        return null;
    }

    public File[] getFiles() {
        Object object = super.getUserObject();
        if (object instanceof File[]) {
            return (File[])object;
        }
        return new File[0];
    }

    @Override
    public boolean isLeaf() {
        return this.mIsLeaf;
    }

    public void lookupSubDirectories() {
        File[] fileArray = FileSystemParserUtility.getInstance().listFiles(this.mFile, false);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!this.isDir(fileArray[i])) continue;
                this.add(new FileTreeNode(this.mFileView, fileArray[i]));
            }
        }
        this.mIsLeaf = this.getChildCount() == 0;
    }

    public void refresh() {
        FileSystemParserUtility.getInstance().clearFile(this.mFile);
        this.removeAllChildren();
        this.lookupSubDirectories();
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isDir(File file) {
        boolean bl = false;
        try {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            bl = file.isDirectory() || fileSystemView.isDrive(file) || fileSystemView.isFloppyDrive(file);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            bl = file.isDirectory();
        }
        return bl;
    }
}

