/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.SimpleTableModel;
import com.qarks.util.ui.swing.TableSorter;
import com.qarks.util.ui.swing.file_chooser.ADirectoryParser;
import com.qarks.util.ui.swing.file_chooser.FileCellRenderer;
import com.qarks.util.ui.swing.file_chooser.FileDate;
import com.qarks.util.ui.swing.file_chooser.FileDragHandler;
import com.qarks.util.ui.swing.file_chooser.FileInfos;
import com.qarks.util.ui.swing.file_chooser.FileProvider;
import com.qarks.util.ui.swing.file_chooser.FileSizeCellRenderer;
import com.qarks.util.ui.swing.file_chooser.FileSystemParserUtility;
import com.qarks.util.ui.swing.file_chooser.IFileSystemParser;
import com.qarks.util.ui.swing.file_chooser.SimpleCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class DirectoryParser
extends ADirectoryParser
implements FileProvider {
    private String[] mFilter = null;
    private String[] mPreviousFilter = null;
    private FileView mFileView = null;
    private File mCurrentDirectory = null;
    private File[] mPreviousList = null;
    private Timer mWorkingTimer = null;
    private ActionListener mWorkingAction = null;
    private IFileSystemParser mFileSystemParser = null;
    private String[] mTitles = new String[0];
    private DirectoryUpdater mUpdater = null;
    private SimpleTableModel mSimpleTableModel = null;
    private TableSorter mSorterTableModel = null;
    private boolean showFolders = true;

    public DirectoryParser(FileView fileView) {
        this(fileView, new String[]{ResourceManager.getString((Object)ResourceKey.NAME), ResourceManager.getString((Object)ResourceKey.DATE), ResourceManager.getString((Object)ResourceKey.TYPE), ResourceManager.getString((Object)ResourceKey.SIZE)});
    }

    public void goToParentDir() {
        File file;
        if (this.mCurrentDirectory != null && (file = this.mCurrentDirectory.getParentFile()) != null) {
            this.setCurrentDirectory(file);
        }
    }

    public void setMultipleSelection(boolean bl) {
        if (bl) {
            super.getSelectionModel().setSelectionMode(2);
        } else {
            super.getSelectionModel().setSelectionMode(0);
        }
    }

    private DirectoryParser(FileView fileView, String[] stringArray) {
        this.mSimpleTableModel = new SimpleTableModel(0, new Class[]{FileInfos.class, FileDate.class, String.class, Long.class}, stringArray);
        this.mSorterTableModel = new TableSorter(this.mSimpleTableModel);
        this.mSorterTableModel.addMouseListenerToHeaderInTable(this);
        this.setModel(this.mSorterTableModel);
        this.mTitles = stringArray;
        this.mWorkingAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryParser.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        };
        this.mWorkingTimer = new Timer(200, this.mWorkingAction);
        this.mWorkingTimer.setRepeats(false);
        this.mFilter = new String[]{"*"};
        this.mPreviousFilter = new String[]{"*"};
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.setOpaque(true);
        this.mFileView = fileView;
        this.setBackground(Color.white);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(1, 0));
        super.setDefaultRenderer(FileInfos.class, new FileCellRenderer(this.mFileView));
        super.setDefaultRenderer(FileDate.class, new SimpleCellRenderer());
        super.setDefaultRenderer(String.class, new SimpleCellRenderer());
        super.setDefaultRenderer(Long.class, new FileSizeCellRenderer());
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FileInfos fileInfos;
                File file;
                int n;
                if (mouseEvent.getClickCount() > 1 && (n = DirectoryParser.this.getSelectedRow()) > -1 && ((file = (fileInfos = (FileInfos)DirectoryParser.this.getValueAt(n, 0)).getFile()).isDirectory() || FileSystemView.getFileSystemView().isComputerNode(file))) {
                    if (DirectoryParser.this.mFileSystemParser != null) {
                        DirectoryParser.this.mFileSystemParser.setCurrentDirectory(fileInfos.getFile());
                    } else {
                        DirectoryParser.this.setCurrentDirectory(fileInfos.getFile());
                    }
                }
            }
        });
        super.setDragEnabled(true);
        super.setTransferHandler(new FileDragHandler(this));
    }

    public void addFileSelectionListener(ListSelectionListener listSelectionListener) {
        super.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeFileSelectionListener(ListSelectionListener listSelectionListener) {
        super.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    @Override
    public File[] getSelectedFiles() {
        File[] fileArray = new File[]{};
        int[] nArray = this.getSelectedRows();
        if (nArray.length > 0) {
            fileArray = new File[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                File file;
                FileInfos fileInfos = (FileInfos)this.getValueAt(nArray[i], 0);
                if (fileInfos == null) continue;
                fileArray[i] = file = fileInfos.getFile();
            }
        }
        return fileArray;
    }

    public boolean currentDirContainsFile(String string) {
        File file;
        boolean bl = false;
        if (string != null && (file = new File(string)).exists()) {
            for (int i = 0; !bl && i < this.mPreviousList.length; ++i) {
                bl = this.mPreviousList[i].getName().equals(string);
            }
        }
        return bl;
    }

    public void setFileSystemParser(IFileSystemParser iFileSystemParser) {
        this.mFileSystemParser = iFileSystemParser;
    }

    private void updateCursor(boolean bl) {
        if (bl) {
            this.mWorkingTimer.start();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.mFileSystemParser != null) {
                this.mFileSystemParser.setCursor(Cursor.getPredefinedCursor(3));
            }
        } else {
            this.mWorkingTimer.stop();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.mFileSystemParser != null) {
                this.mFileSystemParser.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void setWorking(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateCursor(bl);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DirectoryParser.this.updateCursor(bl);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setFilter(String[] stringArray) {
        this.mFilter = stringArray;
        if (this.hasFilterChanged(this.mFilter)) {
            this.mPreviousFilter = this.mFilter;
            if (this.mPreviousList != null) {
                this.updateModelFromDatas(this.mPreviousList);
            } else {
                this.setCurrentDirectory(this.mCurrentDirectory);
            }
        }
    }

    @Override
    public void setCurrentDirectory(File file) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mSimpleTableModel.setRowCount(0);
        this.mSorterTableModel.reallocateIndexes();
        if (this.mUpdater != null) {
            this.mUpdater.cancel();
        }
        this.mUpdater = new DirectoryUpdater(file);
        this.mUpdater.start();
    }

    public void showFolders(boolean bl) {
        this.showFolders = bl;
    }

    private void updateModelFromDatas(File[] fileArray) {
        if (fileArray != null) {
            int n;
            Vector<File> vector = new Vector<File>();
            for (n = 0; n < fileArray.length; ++n) {
                boolean bl = fileArray[n].isDirectory();
                if (bl) {
                    if (!this.showFolders) continue;
                    vector.addElement(fileArray[n]);
                    continue;
                }
                if (!fileArray[n].isFile() || !this.isFileAccepted(fileArray[n])) continue;
                vector.addElement(fileArray[n]);
            }
            this.mSimpleTableModel.setRowCount(vector.size());
            this.mSorterTableModel.reallocateIndexes();
            for (n = 0; n < vector.size(); ++n) {
                File file = (File)vector.elementAt(n);
                FileInfos fileInfos = new FileInfos(this.mFileView, file);
                this.mSorterTableModel.setValueAt(fileInfos, n, 0);
                FileDate fileDate = null;
                fileDate = new FileDate(file);
                this.mSorterTableModel.setValueAt(fileDate, n, 1);
                this.mSorterTableModel.setValueAt(FileSystemParserUtility.getInstance().getTypeDescription(file), n, 2);
                if (!file.isDirectory()) {
                    this.mSorterTableModel.setValueAt(fileInfos.getLength(), n, 3);
                    continue;
                }
                this.mSorterTableModel.setValueAt(null, n, 3);
            }
            this.mSorterTableModel.sortByColumn(0, true);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void updateModel(final TableSorter tableSorter, final int[] nArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setModel(tableSorter);
            for (int i = 0; i < nArray.length; ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DirectoryParser.this.setModel(tableSorter);
                        for (int i = 0; i < nArray.length; ++i) {
                            DirectoryParser.this.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isFileAccepted(File file) {
        boolean bl = false;
        if (file != null) {
            String string = file.getName();
            for (int i = 0; i < this.mFilter.length && !bl; ++i) {
                bl = this.filter(string, this.mFilter[i]);
            }
        }
        return bl;
    }

    private boolean filter(String string, String string2) {
        boolean bl = true;
        while (string2.length() > 0 && bl) {
            String string3;
            int n;
            if (string2.startsWith("*")) {
                while (string2.startsWith("*")) {
                    string2 = string2.substring(1);
                }
                n = string2.indexOf("*");
                string3 = string2;
                if (n > -1) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(string3.length());
                    int n2 = string.indexOf(string3);
                    if (n2 == -1) {
                        bl = false;
                        continue;
                    }
                    string = string.substring(n2);
                    continue;
                }
                string2 = string2.substring(string3.length());
                bl = string.endsWith(string3);
                continue;
            }
            n = string2.indexOf("*");
            string3 = string2;
            if (n > -1) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(string3.length());
                bl = string.startsWith(string3);
                if (!bl) continue;
                string = string.substring(string3.length());
                continue;
            }
            string2 = string2.substring(string3.length());
            bl = string.equals(string3);
        }
        return bl;
    }

    public File getCurrentDirectory() {
        return this.mCurrentDirectory;
    }

    @Override
    public void refreshCurrentDirectory() {
        this.setCurrentDirectory(this.mCurrentDirectory);
    }

    public boolean hasContentChanged(File[] fileArray) {
        int n;
        if (this.mPreviousList == null || fileArray == null || this.mPreviousList.length != fileArray.length) {
            return true;
        }
        Hashtable<File, String> hashtable = new Hashtable<File, String>(2 * this.mPreviousList.length);
        for (n = 0; n < this.mPreviousList.length; ++n) {
            hashtable.put(this.mPreviousList[n], "exists");
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (hashtable.get(fileArray[n]) != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasFilterChanged(String[] stringArray) {
        if (this.mPreviousFilter.length != stringArray.length) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.mPreviousFilter[i].equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ File[] access$302(DirectoryParser directoryParser, File[] fileArray) {
        directoryParser.mPreviousList = fileArray;
        return fileArray;
    }

    private class DirectoryUpdater
    implements Runnable {
        private Thread mThread = null;
        private boolean mCancelled = false;
        private File mRequestedDir = null;

        public DirectoryUpdater(File file) {
            this.mRequestedDir = file;
            this.mThread = new Thread(this);
        }

        public void start() {
            DirectoryParser.this.setWorking(true);
            this.mThread.start();
        }

        public void cancel() {
            this.mCancelled = true;
        }

        @Override
        public void run() {
            final File[] fileArray = this.mRequestedDir.listFiles();
            if (DirectoryParser.this.hasContentChanged(fileArray)) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DirectoryUpdater.this.doUpdate(fileArray);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                DirectoryParser.this.setWorking(false);
            } else {
                DirectoryParser.this.setWorking(false);
            }
        }

        private void doUpdate(File[] fileArray) {
            DirectoryParser.access$302(DirectoryParser.this, fileArray);
            DirectoryParser.this.updateModelFromDatas(fileArray);
            if (!this.mCancelled) {
                DirectoryParser.this.mCurrentDirectory = this.mRequestedDir;
            }
        }
    }
}

