/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.swing.ControlledListSelectionModel;
import com.qarks.util.ui.swing.ISortableObject;
import com.qarks.util.ui.swing.SimpleTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SimpleTableSorterModel
extends SimpleTableModel
implements TableModelListener {
    private int[] indexes;
    private boolean[] ascendingSort;
    private Vector sortingColumns = new Vector();
    private boolean ascending = true;
    private int compares;
    private int previousColSorted = -1;

    public SimpleTableSorterModel(int n, Class[] classArray, String[] stringArray) {
        super(n, classArray, stringArray);
    }

    @Override
    public void setRowCount(int n) {
        super.setRowCount(n);
        this.reallocateIndexes();
    }

    @Override
    public void addRow(Object[] objectArray) {
        super.addRow(objectArray);
        this.reallocateIndexes();
        this.restoreOrder(false);
    }

    public void addRows(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Object[])) continue;
            super.addRow((Object[])objectArray[i]);
        }
        this.reallocateIndexes();
        this.restoreOrder(false);
    }

    @Override
    public void removeRow(int n) {
        super.removeRow(this.indexes[n]);
        this.reallocateIndexes();
        this.restoreOrder(false);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.previousColSorted = n;
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
        this.ascendingSort[n] = bl;
        this.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final SimpleTableSorterModel simpleTableSorterModel = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (n2 != -1) {
                    boolean bl = !SimpleTableSorterModel.this.ascendingSort[n2];
                    int[] nArray = jTable2.getSelectedRows();
                    Object[] objectArray = new Object[nArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = jTable2.getValueAt(nArray[i], n2);
                    }
                    ControlledListSelectionModel controlledListSelectionModel = null;
                    ListSelectionModel listSelectionModel = jTable2.getSelectionModel();
                    if (listSelectionModel instanceof ControlledListSelectionModel) {
                        controlledListSelectionModel = (ControlledListSelectionModel)listSelectionModel;
                        controlledListSelectionModel.setIsAdjusting(true);
                    }
                    simpleTableSorterModel.sortByColumn(n2, bl);
                    for (int i = 0; i < objectArray.length; ++i) {
                        int n3 = SimpleTableSorterModel.this.indexOf(objectArray[i], n2);
                        if (n3 <= -1) continue;
                        jTable2.addRowSelectionInterval(n3, n3);
                    }
                    if (controlledListSelectionModel != null) {
                        controlledListSelectionModel.setIsAdjusting(false);
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        MouseListener[] mouseListenerArray = jTableHeader.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (mouseListenerArray[i] instanceof MouseMotionListener) continue;
            jTableHeader.removeMouseListener(mouseListenerArray[i]);
        }
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public int indexOf(Object object, int n) {
        int n2 = -1;
        boolean bl = false;
        int n3 = this.getRowCount();
        for (int i = 0; !bl && i < n3; ++i) {
            if (this.getValueAt(i, n) != object) continue;
            bl = true;
            n2 = i;
        }
        return n2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return super.getValueAt(this.indexes[n], n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        super.setValueAt(object, this.indexes[n], n2);
    }

    public int getIndex(int n) {
        return this.indexes[n];
    }

    private int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class clazz = this.getColumnClass(n3);
        SimpleTableSorterModel simpleTableSorterModel = this;
        Object object2 = simpleTableSorterModel.getValueAt(n, n3);
        Object object3 = simpleTableSorterModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (simpleTableSorterModel.getValueAt(n, n3) instanceof ISortableObject) {
            ISortableObject iSortableObject = (ISortableObject)simpleTableSorterModel.getValueAt(n, n3);
            ISortableObject iSortableObject2 = (ISortableObject)simpleTableSorterModel.getValueAt(n2, n3);
            return iSortableObject.comparesTo(iSortableObject2);
        }
        if (clazz.getSuperclass() == Number.class) {
            Number number;
            double d;
            Number number2 = (Number)simpleTableSorterModel.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)simpleTableSorterModel.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == Date.class) {
            Date date;
            long l;
            Date date2 = (Date)simpleTableSorterModel.getValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)simpleTableSorterModel.getValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == String.class) {
            String string2;
            String string3 = (String)simpleTableSorterModel.getValueAt(n, n3);
            int n4 = string3.compareTo(string2 = (String)simpleTableSorterModel.getValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)simpleTableSorterModel.getValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)simpleTableSorterModel.getValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = simpleTableSorterModel.getValueAt(n, n3);
        String string4 = object4.toString();
        int n5 = string4.compareTo(string = (object = simpleTableSorterModel.getValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    private int compare(int n, int n2) {
        ++this.compares;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = (Integer)this.sortingColumns.elementAt(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            return this.ascending ? n4 : -n4;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int n;
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        boolean bl = false;
        if (this.ascendingSort != null && this.previousColSorted > -1) {
            bl = this.ascendingSort[this.previousColSorted];
        }
        this.indexes = new int[n2];
        this.ascendingSort = new boolean[n3];
        for (n = 0; n < n2; ++n) {
            this.indexes[n] = n;
        }
        if (this.previousColSorted >= n3) {
            this.previousColSorted = -1;
        }
        for (n = 0; n < n3; ++n) {
            this.ascendingSort[n] = n == this.previousColSorted ? bl : false;
        }
    }

    private void restoreOrder(boolean bl) {
        if (bl) {
            this.previousColSorted = -1;
        } else if (this.previousColSorted > -1) {
            boolean bl2 = this.ascendingSort[this.previousColSorted];
            this.sortByColumn(this.previousColSorted, bl2);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    private void checkModel() {
        if (this.indexes.length != this.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    private void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    private void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    private void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    private void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }
}

