/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.help;

import com.qarks.util.ui.help.HelpNode;
import com.qarks.util.ui.help.HelpParser;
import java.io.File;
import java.net.URL;

public class FileHelpParser
implements HelpParser {
    private File directory;

    public FileHelpParser(File file) {
        this.directory = file;
    }

    @Override
    public HelpNode[] getChildren(HelpNode helpNode) {
        File[] fileArray;
        HelpNode[] helpNodeArray = new FileHelpNode[]{};
        File file = null;
        if (helpNode instanceof FileHelpNode) {
            fileArray = (File[])helpNode;
            file = ((FileHelpNode)fileArray).file;
        } else if (helpNode == null) {
            file = this.directory;
        }
        if (file != null && file.exists()) {
            fileArray = file.listFiles();
            helpNodeArray = new HelpNode[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                String string2 = string = fileArray[i].getName();
                int n = string.lastIndexOf(".");
                if (n > -1) {
                    string2 = string.substring(0, n);
                }
                helpNodeArray[i] = new FileHelpNode(fileArray[i], string2, fileArray[i].isDirectory());
            }
        }
        return helpNodeArray;
    }

    private class FileHelpNode
    extends HelpNode {
        private File file;

        public FileHelpNode(File file, String string, boolean bl) {
            super(string, bl);
            this.file = file;
        }

        @Override
        public void setPageUrl(URL uRL) {
            try {
                this.file = new File(uRL.toURI());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public URL getPageUrl() {
            URL uRL = null;
            try {
                uRL = this.file.toURL();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return uRL;
        }
    }
}

