/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.security;

import com.qarks.util.security.RSAEncryptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Properties;

public class RSAHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePublicKey(RSAPublicKey rSAPublicKey, File file) throws Exception {
        BigInteger bigInteger = rSAPublicKey.getModulus();
        BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
        Properties properties = new Properties();
        properties.setProperty("mod", bigInteger.toString());
        properties.setProperty("exp", bigInteger2.toString());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "");
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePrivateKey(RSAPrivateKey rSAPrivateKey, File file) throws Exception {
        BigInteger bigInteger = rSAPrivateKey.getModulus();
        BigInteger bigInteger2 = rSAPrivateKey.getPrivateExponent();
        Properties properties = new Properties();
        properties.setProperty("mod", bigInteger.toString());
        properties.setProperty("exp", bigInteger2.toString());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "");
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPublicKey restorePublicKey(File file) throws Exception {
        RSAPublicKey rSAPublicKey = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            rSAPublicKey = RSAHelper.restorePublicKey(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return rSAPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey restorePrivateKey(File file) throws Exception {
        RSAPrivateKey rSAPrivateKey = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            rSAPrivateKey = RSAHelper.restorePrivateKey(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return rSAPrivateKey;
    }

    public static RSAPublicKey restorePublicKey(InputStream inputStream) throws Exception {
        RSAPublicKey rSAPublicKey = null;
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = properties.getProperty("mod");
        String string2 = properties.getProperty("exp");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(string), new BigInteger(string2));
        rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        return rSAPublicKey;
    }

    public static RSAPrivateKey restorePrivateKey(InputStream inputStream) throws Exception {
        RSAPrivateKey rSAPrivateKey = null;
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = properties.getProperty("mod");
        String string2 = properties.getProperty("exp");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(new BigInteger(string), new BigInteger(string2));
        rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
        return rSAPrivateKey;
    }

    public static KeyPair generateRSAKeyPair(int n) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static byte[] encrypt(byte[] byArray, RSAPublicKey rSAPublicKey) throws Exception {
        RSAEncryptor rSAEncryptor = new RSAEncryptor(rSAPublicKey);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        rSAEncryptor.encryptStream(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decrypt(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws Exception {
        RSAEncryptor rSAEncryptor = new RSAEncryptor(rSAPrivateKey);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        rSAEncryptor.decryptStream(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

