/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.jdbc;

import com.qarks.util.jdbc.Transaction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class TransactionPool {
    private Vector pool = new Vector();
    private Vector<Connection> connections = new Vector();
    private String driverName;
    private String databaseUrl;
    private String user;
    private String password;
    private boolean closed = true;

    public TransactionPool(String string, String string2, String string3, String string4) {
        this.driverName = string;
        this.databaseUrl = string2;
        this.user = string3;
        this.password = string4;
    }

    public void initPool(int n) {
        this.closed = false;
        for (int i = 0; i < n; ++i) {
            try {
                Connection connection = this.createConnection();
                Transaction transaction = new Transaction(this, connection);
                this.pool.addElement(transaction);
                continue;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void close() {
        this.closed = true;
        for (Connection connection : this.connections) {
            try {
                connection.setAutoCommit(true);
                connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getAvailableTransaction() {
        Transaction transaction = null;
        Vector vector = this.pool;
        synchronized (vector) {
            while (this.pool.isEmpty()) {
                try {
                    this.pool.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            transaction = (Transaction)this.pool.remove(0);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseTransaction(Transaction transaction) {
        block9: {
            try {
                if (!transaction.isClosed()) {
                    this.pool.addElement(transaction);
                    Vector vector = this.pool;
                    synchronized (vector) {
                        this.pool.notifyAll();
                        break block9;
                    }
                }
                Connection connection = this.createConnection();
                transaction = new Transaction(this, connection);
                this.pool.addElement(transaction);
                Vector vector = this.pool;
                synchronized (vector) {
                    this.pool.notifyAll();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Connection createConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("pool is closed");
        }
        Connection connection = null;
        try {
            Class.forName(this.driverName);
            connection = DriverManager.getConnection(this.databaseUrl, this.user, this.password);
            connection.setAutoCommit(false);
            this.connections.add(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection;
    }
}

