/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.swf.FillStyle;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class LineStyle {
    public static final int CAP_ROUND = 0;
    public static final int CAP_NONE = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_ROUND = 0;
    public static final int JOIN_BEVEL = 1;
    public static final int JOIN_MITER = 2;
    private int width;
    private int endWidth;
    private int startCapStyle;
    private int joinStyle;
    private int endCapStyle;
    private boolean hasFillFlag;
    private boolean noHScaleFlag;
    private boolean noVScaleFlag;
    private boolean pixelHintingFlag;
    private boolean noClose;
    private float miterLimitFactor;
    private FillStyle fillStyle;
    private Color color;
    private Color endColor;

    public LineStyle(int width, Color color) {
        this.width = width;
        this.color = color;
        this.startCapStyle = 0;
        this.joinStyle = 0;
        this.endCapStyle = 0;
        this.hasFillFlag = false;
        this.noHScaleFlag = false;
        this.noVScaleFlag = false;
        this.pixelHintingFlag = false;
        this.noClose = false;
    }

    public LineStyle(int width, int endWidth, Color color, Color endColor) {
        this(width, color);
        this.endWidth = endWidth;
        this.endColor = endColor;
    }

    public LineStyle(SWFInputStream input, boolean isMorphStyle, boolean hasAlpha, boolean hasStyles) throws IOException {
        this.width = input.readUnsignedShort();
        if (isMorphStyle) {
            this.endWidth = input.readUnsignedShort();
        }
        if (hasStyles) {
            this.startCapStyle = (int)input.readUBits(2);
            this.joinStyle = (int)input.readUBits(2);
            this.hasFillFlag = input.readBitFlag();
            this.noHScaleFlag = input.readBitFlag();
            this.noVScaleFlag = input.readBitFlag();
            this.pixelHintingFlag = input.readBitFlag();
            input.readUBits(5);
            this.noClose = input.readBitFlag();
            this.endCapStyle = (int)input.readUBits(2);
            if (this.joinStyle == 2) {
                input.readFixed8();
            }
            if (this.hasFillFlag) {
                this.fillStyle = new FillStyle(input, false, true);
            } else {
                this.color = input.readColor(true);
            }
        } else {
            this.color = input.readColor(hasAlpha);
        }
        if (isMorphStyle) {
            this.endColor = input.readColor(true);
        }
    }

    public void write(SWFOutputStream swf, boolean isMorphStyle, boolean hasAlpha, boolean hasStyles) throws IOException {
        swf.writeUnsignedShort(this.width);
        if (isMorphStyle) {
            swf.writeUnsignedShort(this.endWidth);
        }
        if (hasStyles) {
            swf.writeUBits(this.startCapStyle, 2);
            swf.writeUBits(this.joinStyle, 2);
            swf.writeBitFlag(this.hasFillFlag);
            swf.writeBitFlag(this.noHScaleFlag);
            swf.writeBitFlag(this.noVScaleFlag);
            swf.writeBitFlag(this.pixelHintingFlag);
            swf.writeUBits(0L, 5);
            swf.writeBitFlag(this.noClose);
            swf.writeUBits(this.endCapStyle, 2);
            if (this.joinStyle == 2) {
                swf.writeFixed8(this.miterLimitFactor);
            }
            if (this.hasFillFlag) {
                this.fillStyle.write(swf, isMorphStyle, true);
            } else {
                swf.writeColor(this.color, true);
            }
        } else {
            swf.writeColor(this.color, hasAlpha || isMorphStyle);
            if (isMorphStyle) {
                swf.writeColor(this.endColor, true);
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("LineStyle " + this.width + ", " + this.color);
        if (this.endColor != null) {
            s.append("; " + this.endWidth + ", " + this.endColor);
        }
        return s.toString();
    }
}

