% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wpb_table.R
\name{wpb_table}
\alias{wpb_table}
\title{Download and parse World Prison Brief data}
\usage{
wpb_table(region = c("Africa", "Asia", "Caribbean", "Central America",
  "Europe", "Middle East", "North America", "Oceania", "South America", "All"),
  country = NULL)
}
\arguments{
\item{region}{\code{character}. Return details for all the countries in the particular region. For a list of the countries in each region, use \code{wbp_region_list()}.}

\item{country}{\code{character}. If details of a specific country are required, the country can be specified by name. A non-\code{NULL} value for this parameter will void the \code{region} argument. For a list of country names, use \code{wpb_list()}.}
}
\description{
Download and parse World Prison Brief data
}
\examples{
\dontrun{
# Get details for Spain:
espana <- wpb_table(country = "Spain")

# Get details for Central America:
CA <- wpb_table(region = "Central America")
}
}
