% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpn.R, R/ppn.R, R/qpn.R, R/rpn.R
\name{pn}
\alias{pn}
\alias{dpn}
\alias{pn}
\alias{ppn}
\alias{pn}
\alias{qpn}
\alias{pn}
\alias{rpn}
\title{The Power Normal Distribution}
\usage{
dpn(x, lambda, mu = 0, sigma = 1)

ppn(q, lambda, mu = 0, sigma = 1)

qpn(p, lambda, mu = 0, sigma = 1)

rpn(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power normal distribution with parameters mu, sigma and lambda.
}
\examples{
dpn(1, 1, 3, 4)
ppn(1, 1, 3, 4)
qpn(0.2, 1, 3, 4)
rpl(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Bazán, J. L., Romeo, J. S. and Rodrigues, J. (2014) Bayesian skew-probit regression for binary response data. \emph{Brazilian Journal of Probability and Statistics}. \strong{28}(4), 467–482.

Gupta, R. D. and Gupta, R. C. (2008) Analyzing skewed data by power normal model. \emph{Test} \strong{17}, 197–210.

Kundu, D. and Gupta, R. D. (2013) Power-normal distribution. \emph{Statistics} \strong{47}, 110–125.
}
