% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\docType{methods}
\name{mll.reset}
\alias{mll.reset}
\alias{mll.reset,genclone-method}
\alias{mll.reset,snpclone-method}
\title{Reset multilocus lineages}
\usage{
mll.reset(x, value)
}
\arguments{
\item{x}{a \linkS4class{genclone} or \linkS4class{snpclone} object.}

\item{value}{a character vector that specifies which levels you wish to be 
reset.}
}
\value{
an object of the same type as x
}
\description{
This function will allow you to reset multilocus lineages for your data set.
}
\note{
This method has no assignment method. If "original" is not contained in
  "value", it is assumed that the "original" definition will be used to reset
  the MLGs.
}
\examples{

# This data set was a subset of a larger data set, so the multilocus
# genotypes are not all sequential
data(Pinf)
mll(Pinf) <- "original"
mll(Pinf)

# If we use mll.reset, then it will become sequential
Pinf.new <- mll.reset(Pinf, TRUE) # reset all
mll(Pinf.new)

\dontrun{

# It is possible to reset only specific mll definitions. For example, let's
# say that we wanted to filter our multilocus genotypes by nei's distance
mlg.filter(Pinf, dist = nei.dist, missing = "mean") <- 0.02

# And we wanted to set those as custom genotypes,
mll.custom(Pinf) <- mll(Pinf, "contracted")
mll.levels(Pinf) <- .genlab("MLG", nmll(Pinf, "custom"))

# We could reset just the original and the filtered if we wanted to and keep
# the custom as it were.

Pinf.new <- mll.reset(Pinf, c("original", "contracted"))

mll(Pinf.new, "original")
mll(Pinf.new, "contracted")
mll(Pinf.new, "custom")

# If "original" is not one of the values, then that is used as a baseline.
Pinf.orig <- mll.reset(Pinf, "contracted")
mll(Pinf.orig, "contracted")
mll(Pinf.new, "contracted")
}

}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link{mll}} \code{\link{mlg.table}} \code{\link{mll.custom}}
}

