% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaaMLGmethods.R
\docType{methods}
\name{initialize,MLG-method}
\alias{Math,MLG-method}
\alias{Math2,MLG-method}
\alias{Ops,MLG,ANY-method}
\alias{Summary,MLG-method}
\alias{[,MLG,ANY,ANY,ANY-method}
\alias{[<-,MLG,ANY,ANY,ANY-method}
\alias{initialize,MLG-method}
\alias{length,MLG-method}
\alias{show,MLG-method}
\title{Methods used for MLG objects}
\usage{
\S4method{initialize}{MLG}(.Object, mlg)

\S4method{[}{MLG,ANY,ANY,ANY}(x, i, j, ..., all = FALSE, drop = TRUE)

\S4method{[}{MLG,ANY,ANY,ANY}(x, i, j) <- value

\S4method{show}{MLG}(object)

\S4method{length}{MLG}(x)

\S4method{Ops}{MLG,ANY}(e1, e2)

\S4method{Math}{MLG}(x)

\S4method{Math2}{MLG}(x, digits)

\S4method{Summary}{MLG}(x, ..., na.rm = FALSE)
}
\arguments{
\item{.Object}{a character, "MLG"}

\item{mlg}{a vector where each element assigns the multilocus genotype of 
that individual in the data set.}

\item{x}{an MLG object}

\item{i}{a vector of integers or logical values to index the MLG vector.}

\item{j}{One of 
\itemize{
 \item "original"
 \item "expanded"
 \item "contracted"
 \item "custom"
}}

\item{...}{passed on to summary methods}

\item{all}{a logical value indicating whether or not to return the subset of
all MLG values or only the numeric.}

\item{value}{the vector of MLGs to replace. \strong{For internal use only}.}

\item{object}{an MLG object.}

\item{e1}{an MLG object}

\item{e2}{a number}

\item{digits}{the number of digits to retain}

\item{na.rm}{passed on to summary methods}
}
\description{
Default methods for accessing and subsetting MLG objects.
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\linkS4class{MLG}} \code{\linkS4class{genclone}}
  \code{\linkS4class{snpclone}} \code{\link{visible}} 
  \code{\link{unique,MLG-method}} \code{\link{levels,MLG-method}}
}
\keyword{internal}

