% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{thinmap}
\alias{thinmap}
\title{Thin out map data}
\usage{
thinmap(
  maplist,
  dosage_matrix,
  bin_size = 1,
  bounds = NULL,
  remove_markers = NULL,
  plot_maps = TRUE,
  use_SN_phase = FALSE,
  parent1 = "P1",
  parent2 = "P2",
  log = NULL
)
}
\arguments{
\item{maplist}{A list of maps. In the first column marker names and in the second their position.}

\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{bin_size}{Numeric. Size (in cM) of the bins to include. By default, a bin size of 1 cM is used. Larger \code{bin_size} results in 
fewer markers being left on the resulting map.}

\item{bounds}{Numeric vector. If \code{NULL} (by default) then all positions are included, however if specified then output
is limited to a specific region, which may be useful if fine-mapping a region of interest.}

\item{remove_markers}{Optional vector of marker names to remove from the maps. Default is \code{NULL}.}

\item{plot_maps}{Logical. Plot the marker positions of the selected markers using \code{polymapR::plot_map}.}

\item{use_SN_phase}{Logical, by default \code{FALSE}. If \code{TRUE}, then 1x0 and 0x1 are binned per phase, to increase coverage of these
marker types across parental homologues. If not, at most one of each are retained per bin.}

\item{parent1}{Identifier of parent 1, by default assumed to be \code{"P1"}}

\item{parent2}{Identifier of parent 2, by default assumed to be \code{"P2"}}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
A maplist of the same structure as the input maplist, but with fewer markers based on the bin_size.
}
\description{
\code{thinmap} is a function for thinning out an integrated map, in order that IBD estimation runs more quickly. Especially
useful for maps with very high marker densities for which the \code{\link{estimate_IBD}} function is to be used.
}
\examples{
data("phased_maplist.4x","SNP_dosages.4x")
maplist_thin<-thinmap(maplist=phased_maplist.4x,dosage_matrix=SNP_dosages.4x)
}
