% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{findPeak}
\alias{findPeak}
\title{Function to find the position of maximum LOD on a particular linkage group}
\usage{
findPeak(LOD_data, linkage_group, verbose = TRUE)
}
\arguments{
\item{LOD_data}{Output of \code{\link{QTLscan}} function.}

\item{linkage_group}{Numeric identifier of the linkage group being tested, based on the order of \code{IBD_list}.
Only a single linkage group is allowed.}

\item{verbose}{Should messages be written to standard output? By default \code{TRUE}.}
}
\description{
Given QTL output, this function returns the position of maximum LOD for a specified linkage group.
}
\examples{
data("qtl_LODs.4x")
findPeak(LOD_data=qtl_LODs.4x,linkage_group=1)
}
