% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_eval_functions.R
\name{plot.policy_eval}
\alias{plot.policy_eval}
\title{Plot histogram of the influence curve for a \code{policy_eval} object}
\usage{
\method{plot}{policy_eval}(x, ...)
}
\arguments{
\item{x}{Object of class \link{policy_eval}}

\item{...}{Additional arguments}
}
\description{
Plot histogram of the influence curve for a \code{policy_eval} object
}
\examples{
d <- sim_two_stage(2e3, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  baseline = "BB",
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))

pe <- policy_eval(pd,
                  policy_learn = policy_learn())

plot(pe)
}
