% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_string_info}
\alias{tt_string_info}
\title{Table Transformer: obtain a summary table for string columns}
\usage{
tt_string_info(tbl)
}
\arguments{
\item{tbl}{A table object to be used as input for the transformation. This
can be a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}
}
\value{
A \code{tibble} object.
}
\description{
With any table object, you can produce a summary table that is scoped to
string-based columns. The output summary table will have a leading column
called \code{".param."} with labels for each of the three rows, each corresponding
to the following pieces of information pertaining to string length:
\enumerate{
\item Mean String Length (\code{"length_mean"})
\item Minimum String Length (\code{"length_min"})
\item Maximum String Length (\code{"length_max"})
}

Only string data from the input table will generate columns in the output
table. Column names from the input will be used in the output, preserving
order as well.
}
\section{Examples}{


Get string information for the string-based columns in the \code{game_revenue}
dataset that is included in the \strong{pointblank} package.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tt_string_info(tbl = game_revenue)
#> # A tibble: 3 x 7
#>   .param.     player_id session_id item_type item_name acquisition country
#>   <chr>           <dbl>      <dbl>     <dbl>     <dbl>       <dbl>   <dbl>
#> 1 length_mean        15         24      2.22      7.35        7.97    8.53
#> 2 length_min         15         24      2         5           5       5   
#> 3 length_max         15         24      3        11          14      14
}\if{html}{\out{</div>}}

Ensure that \code{player_id} and \code{session_id} values always have the same fixed
numbers of characters (\code{15} and \code{24}, respectively) throughout the table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tt_string_info(tbl = game_revenue) \%>\%
  col_vals_equal(
    columns = vars(player_id),
    value = 15
  ) \%>\%
  col_vals_equal(
    columns = vars(session_id),
    value = 24
  )
#> # A tibble: 3 x 7
#>   .param.     player_id session_id item_type item_name acquisition country
#>   <chr>           <dbl>      <dbl>     <dbl>     <dbl>       <dbl>   <dbl>
#> 1 length_mean        15         24      2.22      7.35        7.97    8.53
#> 2 length_min         15         24      2         5           5       5   
#> 3 length_max         15         24      3        11          14      14
}\if{html}{\out{</div>}}

We see data, and not an error, so both validations were successful!

Let's use a \code{tt_string_info()}-transformed table with the
\code{\link[=test_col_vals_lte]{test_col_vals_lte()}} to check that the maximum string length in column \code{f}
of the \code{small_table} dataset is no greater than \code{4}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tt_string_info(tbl = small_table) \%>\%
  test_col_vals_lte(
    columns = vars(f),
    value = 4
  )
#> [1] TRUE
}\if{html}{\out{</div>}}
}

\section{Function ID}{

12-2
}

\seealso{
Other Table Transformers: 
\code{\link{get_tt_param}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
