% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_fn.R
\name{get_data_class}
\alias{get_data_class}
\title{Return data_class of statRes or trelliData object}
\usage{
get_data_class(dcObj)
}
\arguments{
\item{dcObj}{an object of class 'statRes' or 'trelliData'}
}
\value{
returns the data_class attribute from a 'statRes' or 'trelliData'
  object
}
\description{
This function returns data_class attribute from statRes or trelliData object,
inherited from the omicsData used in \code{\link{imd_anova}} or
\code{\link{as.trelliData}}
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

my_prodata = group_designation(
  omicsData = pro_object,
  main_effects = c("Phenotype")
)

imdanova_Filt = imdanova_filter(omicsData = my_prodata)

my_prodata = applyFilt(
  filter_object = imdanova_Filt,
  omicsData = my_prodata,
  min_nonmiss_anova = 2
)

imd_anova_res = imd_anova(
  omicsData = my_prodata,
  test_method = 'comb',
  pval_adjust_a_multcomp = 'bon',
  pval_adjust_g_multcomp = 'bon'
)

result = get_data_class(imd_anova_res)
\dontshow{\}) # examplesIf}
}
