% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfolds2Pressind.R
\name{kfolds2Pressind}
\alias{kfolds2Pressind}
\title{Computes individual PRESS for k-fold cross validated partial least squares
regression models.}
\usage{
kfolds2Pressind(pls_kfolds)
}
\arguments{
\item{pls_kfolds}{a k-fold cross validated partial least squares regression
model}
}
\value{
\item{list}{Individual Press vs number of components for the first
group partition} \item{list()}{\dots{}} \item{list}{Individual Press vs
number of components for the last group partition}
}
\description{
This function computes individual PRESS for k-fold cross validated partial
least squares regression models.
}
\note{
Use \code{\link{cv.plsR}} to create k-fold cross validated partial
least squares regression models.
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
kfolds2Pressind(cv.plsR(object=yCornell,dataX=data.frame(scale(as.matrix(XCornell))[,]),
nt=6,K=12,NK=1))
kfolds2Pressind(cv.plsR(object=yCornell,dataX=data.frame(scale(as.matrix(XCornell))[,]),
nt=6,K=6,NK=1))
rm(list=c("XCornell","yCornell"))

\donttest{
data(pine)
Xpine<-pine[,1:10]
ypine<-pine[,11]
kfolds2Pressind(cv.plsR(object=ypine,dataX=Xpine,nt=10,NK=1,verbose=FALSE))
kfolds2Pressind(cv.plsR(object=ypine,dataX=Xpine,nt=10,NK=2,verbose=FALSE))

XpineNAX21 <- Xpine
XpineNAX21[1,2] <- NA
kfolds2Pressind(cv.plsR(object=ypine,dataX=XpineNAX21,nt=10,NK=1,verbose=FALSE))
kfolds2Pressind(cv.plsR(object=ypine,dataX=XpineNAX21,nt=10,NK=2,verbose=FALSE))
rm(list=c("Xpine","XpineNAX21","ypine"))
}

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Societe Francaise de Statistique},
151(2), pages 1-18.
\url{http://publications-sfds.math.cnrs.fr/index.php/J-SFdS/article/view/47}
}
\seealso{
\code{\link{kfolds2coeff}}, \code{\link{kfolds2Press}},
\code{\link{kfolds2Mclassedind}} and \code{\link{kfolds2Mclassed}} to
extract and transforms results from k-fold cross validation.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
\keyword{regression}
