% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_efourier.R
\name{efourier_shape}
\alias{efourier_shape}
\title{Draw shapes based on Fourier coefficients}
\usage{
efourier_shape(
  an = NULL,
  bn = NULL,
  cn = NULL,
  dn = NULL,
  n = 1,
  nharm = NULL,
  npoints = 150,
  alpha = 4,
  plot = TRUE
)
}
\arguments{
\item{an}{The \eqn{a_n} Fourier coefficients on which to calculate a shape.}

\item{bn}{The \eqn{b_n} Fourier coefficients on which to calculate a shape.}

\item{cn}{The \eqn{c_n} Fourier coefficients on which to calculate a shape.}

\item{dn}{The \eqn{d_n} Fourier coefficients on which to calculate a shape.}

\item{n}{The number of shapes to generate. Defaults to 1. If more than one
shape is used, a list of coordinates is returned.}

\item{nharm}{The number of harmonics to use. It must be less than or equal to
the length of \verb{*_n} coefficients.}

\item{npoints}{The number of points to calculate.}

\item{alpha}{The power coefficient associated with the (usually decreasing)
amplitude of the Fourier coefficients.}

\item{plot}{Logical indicating Whether to plot the shape. Defaults to ´TRUE`}
}
\value{
A list with components:
\itemize{
\item \code{x} vector of x-coordrdinates
\item \code{y} vector of y-coordrdinates.
}
}
\description{
Calculates a 'Fourier elliptical shape' given Fourier coefficients
}
\details{
\code{efourier_shape} can be used by specifying \code{nharm} and
\code{alpha}. The coefficients are then sampled in an uniform distribution
\eqn{(-\pi ; \pi)} and this amplitude is then divided by \eqn{harmonicrank ^
alpha}. If \code{alpha} is lower than 1, consecutive coefficients will thus
increase. See Claude (2008) pp.223 for the maths behind inverse ellipitical
Fourier

Adapted from Claude (2008). pp. 223.
}
\examples{
library(pliman)
# approximation of the third leaf's perimeter
# 4 harmonics
image_pliman("potato_leaves.jpg", plot = TRUE)

efourier_shape(an = c(-7.34,  1.81,  -1.32, 0.50),
               bn = c(-113.88, 21.90, -0.31, -6.14),
               cn = c(-147.51, -20.89, 0.66, -14.06),
               dn = c(-0.48, 2.36, -4.36, 3.03))

}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
