% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_efourier.R
\name{efourier_error}
\alias{efourier_error}
\title{Erros between the original and reconstructed outline}
\usage{
efourier_error(
  x,
  nharm = NULL,
  type = c("error", "outline", "deviations"),
  plot = TRUE,
  ncol = NULL,
  nrow = NULL
)
}
\arguments{
\item{x}{An object computed with \code{\link[=efourier]{efourier()}}.}

\item{nharm}{An integer or vector of integers indicating the number of
harmonics to use. If not specified the number of harmonics used in \code{x} is
used.}

\item{type}{The type of plot to produce. By default, a line plot with the sum
of squared distances (y-axis) and the number of harmonics (x-axis) is
produced. If \code{type = "outline"} is used, a plot with the original polygon
and the constructed outline is produced. If \code{type = "deviations"} is used,
a plot with the deviations from the original outline and reconstructed
outline (y-axis) and points along the outline (x-axis) is produced.}

\item{plot}{A logical to inform if a plot should be produced. Defaults to
\code{TRUE}.}

\item{ncol, nrow}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}
}
\value{
A list with the objects:
\itemize{
\item \code{dev_points} A list with the deviations (distances) from original and
predicted outline for each pixel of the outline.
\item \code{data.frame} object with the minimum, maximum and average
deviations (based on the outline points).
}

If \code{x} is an object of class \code{efourier_lst}, a list will be returned.
}
\description{
Computes the sum of squared distances between the original data and
reconstructed outline. It allows examining reconstructed outlines with the
addition of successive contributing harmonics indicated in the argument
\code{nharm}.
}
\examples{
library(pliman)
ef <-
  contours[[1]] |>
  efourier(nharm = 30)

efourier_error(ef)

efourier_error(ef,
               nharm = 30,
               type = "outline")

efourier_error(ef,
               nharm = c(1, 4, 20),
               type = "deviations")
}
