% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_sequence}
\alias{async_sequence}
\title{Compose asynchronous functions}
\usage{
async_sequence(..., .list = NULL)
}
\arguments{
\item{...}{Asynchronous functions to compose.}

\item{.list}{Mose asynchronous functions to compose.}
}
\value{
Asynchronous function, the composition of all input functions.
They are performed left to right, the ones in \code{.list} are the last
ones.
}
\description{
This is equivalent to using the \code{$then()} method of a deferred, but
it is easier to use programmatically.
}
\examples{
\donttest{
check_url <- async_sequence(
  http_head, function(x) identical(x$status_code, 200L))
synchronise(check_url("https://eu.httpbin.org/status/404"))
synchronise(check_url("https://eu.httpbin.org/status/200"))
}
}
\seealso{
Other async control flow: \code{\link{async_reflect}},
  \code{\link{async_retryable}}, \code{\link{async_retry}},
  \code{\link{async_try_each}}, \code{\link{async_until}},
  \code{\link{async_whilst}}
}
\concept{async control flow}
