% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_versions}
\alias{pin_versions}
\title{Pin Versions}
\usage{
pin_versions(name, board = NULL, full = FALSE, ...)
}
\arguments{
\item{name}{The exact name of the pin to match when searching.}

\item{board}{The board name used to find the pin.}

\item{full}{Should the full versioned paths be shown? Defaults to \code{FALSE}.}

\item{...}{Additional parameters.}
}
\description{
Retrieve versions available for a given pin.
}
\examples{
library(pins)

# define local board with versioning enabled
board_register_local(cache = tempfile(), versions = TRUE)

# cache the mtcars dataset
pin(mtcars, name = "mtcars")

# cache variation of the mtcars dataset
pin(mtcars * 10, name = "mtcars")

# print the mtcars versions
versions <- pin_versions("mtcars") \%>\% print()

# retrieve the original version
pin_get("mtcars", version = versions$version[1])

# retrieve the variation version
pin_get("mtcars", version = versions$version[2])
}
