% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeDepthFrac.R
\name{nodeDepthFrac}
\alias{nodeDepthFrac}
\title{Fraction of nodes beyond a given depth}
\usage{
nodeDepthFrac(tree, threshold)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{threshold}{a threshold value for node depth.}
}
\value{
The fraction of nodes with a depth greater than or equal to the threshold (see \code{\link{nodeDepth}} for more details on the meaning of node depth).
}
\description{
Calculate the fraction of nodes with a depth greater than or equal to a given threshold.
}
\examples{
## Find the fraction of nodes with a depth of 5 or more, in a random tree with 20 tips:
tree <- rtree(20)
tree$edge.length <- rep(1,38) # so that the depths are easier to view in a plot
plot(tree)
nodeDepthFrac(tree,threshold=5) 

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
\seealso{
\code{\link{nodeDepth}}
}

