% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textgrid_to_df.R
\name{textgrid_to_df}
\alias{textgrid_to_df}
\title{TextGrid to dataframe}
\usage{
textgrid_to_df(file_name)
}
\arguments{
\item{file_name}{string with a filename or path to the TextGrid}
}
\value{
a dataframe with columns:  \code{id}, \code{time_start},
\code{time_end} (if it is an interval tier -- the same as the start value),
\code{content}, \code{tier}, \code{tier_name} and \code{source}
}
\description{
Convert Praat TextGrid to a dataframe.
}
\examples{
textgrid_to_df(system.file("extdata", "test.TextGrid",
  package = "phonfieldwork"
))

# this is and example of reading a short .TextGrid format
textgrid_to_df(system.file("extdata", "test_short.TextGrid",
  package = "phonfieldwork"
))
}
\author{
George Moroz <agricolamz@gmail.com>
}
