% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_SNV_utility_functions.R
\name{getNextFromFocal}
\alias{getNextFromFocal}
\title{Next SNV from the focal point}
\usage{
getNextFromFocal(current, absDist)
}
\arguments{
\item{current}{Current SNVs in the neighborhood of focal SNV.}

\item{absDist}{Absolute distance of all SNVs from the focal SNV in base pairs.}
}
\value{
The index of the SNV that is nearest to the focal SNV but outside the current neighborhood.
        To be returned to \code{\link{findSNVs}}.
}
\description{
This function finds the next SNV to be checked for compatability with the existing window of SNVs.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# Focal SNV   
focalSNV = 10

# Proximity to the focal SNV.
absDistFromFocal = abs(ex_hapMatSmall_data$posns - ex_hapMatSmall_data$posns[focalSNV]) 

# Next SNV from the focal SNV

nxtSNV = getNextFromFocal(current = c(focalSNV,focalSNV), absDistFromFocal)


}

}
\seealso{
\code{\link{findSNVs}}
}
\keyword{internal}
