% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RV_test.R
\name{RVtest}
\alias{RVtest}
\title{RV test for association of two distance matrices}
\usage{
RVtest(Dx, Dy, nperm)
}
\arguments{
\item{Dx}{A numeric matrix of pairwise distances.}

\item{Dy}{A second numeric matrix of pairwise distances.}

\item{nperm}{The number of times to permute  the rows and columns of \code{Dy}.}
}
\value{
A list contains RV coefficient and permutation P value.
}
\description{
This function performs RV test for similarity of two distance matrices. It permutes rows and columns
of the second matrix randomly to calculate P value.
}
\examples{
x <- runif(8)
y <- runif(8)
# Distance matrices
distX = as.matrix(dist(x, upper = TRUE, diag = TRUE))
distY = as.matrix(dist(y, upper = TRUE, diag = TRUE))

RVtest(Dx = distX, Dy = distY, nperm = 1000)

}
\references{
Robert, P. and Escoufier, Y. (1976) A Unifying tool for linear multivariate statistical
            methods: the RV-coefficient. Applied Statistics, Vol.25, No.3, p. 257-265.
}
