% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{atop_alliance}
\alias{atop_alliance}
\title{Alliance Treaty Obligations and Provisions (ATOP) Project Data (v. 5.0)}
\format{
A data frame with 272,046 observations on the following eight variables.
\describe{
\item{\code{ccode1}}{a numeric vector for the Correlates of War state code for the first state}
\item{\code{ccode2}}{a numeric vector for the Correlates of War state code for the second state}
\item{\code{year}}{a numeric vector for the year}
\item{\code{atop_defense}}{a numeric vector that equals 1 if there was an alliance observed with a defense pledge}
\item{\code{atop_offense}}{a numeric vector that equals 1 if there was an alliance observed with a offense pledge}
\item{\code{atop_neutral}}{a numeric vector that equals 1 if there was an alliance observed with a neutrality pledge}
\item{\code{atop_nonagg}}{a numeric vector that equals 1 if there was an alliance observed with a non-aggression pledge}
\item{\code{atop_consul}}{a numeric vector that equals 1 if there was an alliance observed with a consultation pledge}
}
}
\usage{
atop_alliance
}
\description{
These are directed dyad-year-level data for alliance obligations and provisions from the ATOP project
}
\details{
The \code{data-raw} directory on the project's Github shows how the data were processed.
}
\references{
Leeds, Brett Ashley, Jeffrey M. Ritter, Sara McLaughlin Mitchell, and Andrew G. Long. 2002.
Alliance Treaty Obligations and Provisions, 1815-1944. \emph{International Interactions} 28: 237-60.
}
\keyword{datasets}
