% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_search_faces}
\alias{rekognition_search_faces}
\title{For a given input face ID, searches for matching faces in the collection
the face belongs to}
\usage{
rekognition_search_faces(CollectionId, FaceId, MaxFaces,
  FaceMatchThreshold)
}
\arguments{
\item{CollectionId}{[required] ID of the collection the face belongs to.}

\item{FaceId}{[required] ID of a face to find matches for in the collection.}

\item{MaxFaces}{Maximum number of faces to return. The operation returns the maximum
number of faces with the highest confidence in the match.}

\item{FaceMatchThreshold}{Optional value specifying the minimum confidence in the face match to
return. For example, don\'t return any matches where confidence in
matches is less than 70\%. The default value is 80\%.}
}
\description{
For a given input face ID, searches for matching faces in the collection
the face belongs to. You get a face ID when you add a face to the
collection using the IndexFaces operation. The operation compares the
features of the input face with faces in the specified collection.
}
\details{
You can also search faces without indexing faces by using the
\code{SearchFacesByImage} operation.

The operation response returns an array of faces that match, ordered by
similarity score with the highest similarity first. More specifically,
it is an array of metadata for each face match that is found. Along with
the metadata, the response also includes a \code{confidence} value for each
face match, indicating the confidence that the specific face matches the
input face.

For an example, see Searching for a Face Using Its Face ID in the Amazon
Rekognition Developer Guide.

This operation requires permissions to perform the
\code{rekognition:SearchFaces} action.
}
\section{Request syntax}{
\preformatted{svc$search_faces(
  CollectionId = "string",
  FaceId = "string",
  MaxFaces = 123,
  FaceMatchThreshold = 123.0
)
}
}

\examples{
\dontrun{
# This operation searches for matching faces in the collection the
# supplied face belongs to.
svc$search_faces(
  CollectionId = "myphotos",
  FaceId = "70008e50-75e4-55d0-8e80-363fb73b3a14",
  FaceMatchThreshold = 90L,
  MaxFaces = 10L
)
}

}
\keyword{internal}
