% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalizeevents_operations.R
\name{personalizeevents_put_events}
\alias{personalizeevents_put_events}
\title{Records user interaction event data}
\usage{
personalizeevents_put_events(trackingId, userId, sessionId, eventList)
}
\arguments{
\item{trackingId}{[required] The tracking ID for the event. The ID is generated by a call to the
\href{https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html}{CreateEventTracker}
API.}

\item{userId}{The user associated with the event.}

\item{sessionId}{[required] The session ID associated with the user\'s visit.}

\item{eventList}{[required] A list of event data from the session.}
}
\description{
Records user interaction event data.
}
\section{Request syntax}{
\preformatted{svc$put_events(
  trackingId = "string",
  userId = "string",
  sessionId = "string",
  eventList = list(
    list(
      eventId = "string",
      eventType = "string",
      properties = "string",
      sentAt = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}

\keyword{internal}
