# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include personalize_service.R
NULL

#' Creates a batch inference job
#'
#' Creates a batch inference job. The operation can handle up to 50 million
#' records and the input file must be in JSON format. For more information,
#' see recommendations-batch.
#'
#' @usage
#' personalize_create_batch_inference_job(jobName, solutionVersionArn,
#'   numResults, jobInput, jobOutput, roleArn)
#'
#' @param jobName &#91;required&#93; The name of the batch inference job to create.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version that will be used
#' to generate the batch inference recommendations.
#' @param numResults The number of recommendations to retreive.
#' @param jobInput &#91;required&#93; The Amazon S3 path that leads to the input file to base your
#' recommendations on. The input material must be in JSON format.
#' @param jobOutput &#91;required&#93; The path to the Amazon S3 bucket where the job\'s output will be stored.
#' @param roleArn &#91;required&#93; The ARN of the Amazon Identity and Access Management role that has
#' permissions to read and write to your input and out Amazon S3 buckets
#' respectively.
#'
#' @section Request syntax:
#' ```
#' svc$create_batch_inference_job(
#'   jobName = "string",
#'   solutionVersionArn = "string",
#'   numResults = 123,
#'   jobInput = list(
#'     s3DataSource = list(
#'       path = "string",
#'       kmsKeyArn = "string"
#'     )
#'   ),
#'   jobOutput = list(
#'     s3DataDestination = list(
#'       path = "string",
#'       kmsKeyArn = "string"
#'     )
#'   ),
#'   roleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_batch_inference_job
personalize_create_batch_inference_job <- function(jobName, solutionVersionArn, numResults = NULL, jobInput, jobOutput, roleArn) {
  op <- new_operation(
    name = "CreateBatchInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_batch_inference_job_input(jobName = jobName, solutionVersionArn = solutionVersionArn, numResults = numResults, jobInput = jobInput, jobOutput = jobOutput, roleArn = roleArn)
  output <- .personalize$create_batch_inference_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_batch_inference_job <- personalize_create_batch_inference_job

#' Creates a campaign by deploying a solution version
#'
#' Creates a campaign by deploying a solution version. When a client calls
#' the
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' and
#' [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html)
#' APIs, a campaign is specified in the request.
#' 
#' **Minimum Provisioned TPS and Auto-Scaling**
#' 
#' A transaction is a single `GetRecommendations` or
#' `GetPersonalizedRanking` call. Transactions per second (TPS) is the
#' throughput and unit of billing for Amazon Personalize. The minimum
#' provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput
#' provisioned by Amazon Personalize, and thus, the minimum billing charge.
#' If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize
#' auto-scales the provisioned capacity up and down, but never below
#' `minProvisionedTPS`, to maintain a 70% utilization. There\'s a short
#' time delay while the capacity is increased that might cause loss of
#' transactions. It\'s recommended to start with a low `minProvisionedTPS`,
#' track your usage using Amazon CloudWatch metrics, and then increase the
#' `minProvisionedTPS` as necessary.
#' 
#' **Status**
#' 
#' A campaign can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' -   DELETE PENDING \\> DELETE IN\\_PROGRESS
#' 
#' To get the campaign status, call DescribeCampaign.
#' 
#' Wait until the `status` of the campaign is `ACTIVE` before asking the
#' campaign for recommendations.
#' 
#' **Related APIs**
#' 
#' -   ListCampaigns
#' 
#' -   DescribeCampaign
#' 
#' -   UpdateCampaign
#' 
#' -   DeleteCampaign
#'
#' @usage
#' personalize_create_campaign(name, solutionVersionArn, minProvisionedTPS)
#'
#' @param name &#91;required&#93; A name for the new campaign. The campaign name must be unique within
#' your account.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version to deploy.
#' @param minProvisionedTPS &#91;required&#93; Specifies the requested minimum provisioned transactions
#' (recommendations) per second that Amazon Personalize will support.
#'
#' @section Request syntax:
#' ```
#' svc$create_campaign(
#'   name = "string",
#'   solutionVersionArn = "string",
#'   minProvisionedTPS = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_campaign
personalize_create_campaign <- function(name, solutionVersionArn, minProvisionedTPS) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_campaign_input(name = name, solutionVersionArn = solutionVersionArn, minProvisionedTPS = minProvisionedTPS)
  output <- .personalize$create_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_campaign <- personalize_create_campaign

#' Creates an empty dataset and adds it to the specified dataset group
#'
#' Creates an empty dataset and adds it to the specified dataset group. Use
#' CreateDatasetImportJob to import your training data to a dataset.
#' 
#' There are three types of datasets:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#' 
#' Each dataset type has an associated schema with required field types.
#' Only the `Interactions` dataset is required in order to train a model
#' (also referred to as creating a solution).
#' 
#' A dataset can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' -   DELETE PENDING \\> DELETE IN\\_PROGRESS
#' 
#' To get the status of the dataset, call DescribeDataset.
#' 
#' **Related APIs**
#' 
#' -   CreateDatasetGroup
#' 
#' -   ListDatasets
#' 
#' -   DescribeDataset
#' 
#' -   DeleteDataset
#'
#' @usage
#' personalize_create_dataset(name, schemaArn, datasetGroupArn,
#'   datasetType)
#'
#' @param name &#91;required&#93; The name for the dataset.
#' @param schemaArn &#91;required&#93; The ARN of the schema to associate with the dataset. The schema defines
#' the dataset fields.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to add the dataset
#' to.
#' @param datasetType &#91;required&#93; The type of dataset.
#' 
#' One of the following (case insensitive) values:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#'
#' @section Request syntax:
#' ```
#' svc$create_dataset(
#'   name = "string",
#'   schemaArn = "string",
#'   datasetGroupArn = "string",
#'   datasetType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset
personalize_create_dataset <- function(name, schemaArn, datasetGroupArn, datasetType) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_dataset_input(name = name, schemaArn = schemaArn, datasetGroupArn = datasetGroupArn, datasetType = datasetType)
  output <- .personalize$create_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset <- personalize_create_dataset

#' Creates an empty dataset group
#'
#' Creates an empty dataset group. A dataset group contains related
#' datasets that supply data for training a model. A dataset group can
#' contain at most three datasets, one for each type of dataset:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#' 
#' To train a model (create a solution), a dataset group that contains an
#' `Interactions` dataset is required. Call CreateDataset to add a dataset
#' to the group.
#' 
#' A dataset group can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' -   DELETE PENDING
#' 
#' To get the status of the dataset group, call DescribeDatasetGroup. If
#' the status shows as CREATE FAILED, the response includes a
#' `failureReason` key, which describes why the creation failed.
#' 
#' You must wait until the `status` of the dataset group is `ACTIVE` before
#' adding a dataset to the group.
#' 
#' You can specify an AWS Key Management Service (KMS) key to encrypt the
#' datasets in the group. If you specify a KMS key, you must also include
#' an AWS Identity and Access Management (IAM) role that has permission to
#' access the key.
#' 
#' **APIs that require a dataset group ARN in the request**
#' 
#' -   CreateDataset
#' 
#' -   CreateEventTracker
#' 
#' -   CreateSolution
#' 
#' **Related APIs**
#' 
#' -   ListDatasetGroups
#' 
#' -   DescribeDatasetGroup
#' 
#' -   DeleteDatasetGroup
#'
#' @usage
#' personalize_create_dataset_group(name, roleArn, kmsKeyArn)
#'
#' @param name &#91;required&#93; The name for the new dataset group.
#' @param roleArn The ARN of the IAM role that has permissions to access the KMS key.
#' Supplying an IAM role is only valid when also specifying a KMS key.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of a KMS key used to encrypt the
#' datasets.
#'
#' @section Request syntax:
#' ```
#' svc$create_dataset_group(
#'   name = "string",
#'   roleArn = "string",
#'   kmsKeyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_group
personalize_create_dataset_group <- function(name, roleArn = NULL, kmsKeyArn = NULL) {
  op <- new_operation(
    name = "CreateDatasetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_dataset_group_input(name = name, roleArn = roleArn, kmsKeyArn = kmsKeyArn)
  output <- .personalize$create_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_group <- personalize_create_dataset_group

#' Creates a job that imports training data from your data source (an
#' Amazon S3 bucket) to an Amazon Personalize dataset
#'
#' Creates a job that imports training data from your data source (an
#' Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon
#' Personalize to import the training data, you must specify an AWS
#' Identity and Access Management (IAM) role that has permission to read
#' from the data source.
#' 
#' The dataset import job replaces any previous data in the dataset.
#' 
#' **Status**
#' 
#' A dataset import job can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' To get the status of the import job, call DescribeDatasetImportJob,
#' providing the Amazon Resource Name (ARN) of the dataset import job. The
#' dataset import is complete when the status shows as ACTIVE. If the
#' status shows as CREATE FAILED, the response includes a `failureReason`
#' key, which describes why the job failed.
#' 
#' Importing takes time. You must wait until the status shows as ACTIVE
#' before training a model using the dataset.
#' 
#' **Related APIs**
#' 
#' -   ListDatasetImportJobs
#' 
#' -   DescribeDatasetImportJob
#'
#' @usage
#' personalize_create_dataset_import_job(jobName, datasetArn, dataSource,
#'   roleArn)
#'
#' @param jobName &#91;required&#93; The name for the dataset import job.
#' @param datasetArn &#91;required&#93; The ARN of the dataset that receives the imported data.
#' @param dataSource &#91;required&#93; The Amazon S3 bucket that contains the training data to import.
#' @param roleArn &#91;required&#93; The ARN of the IAM role that has permissions to read from the Amazon S3
#' data source.
#'
#' @section Request syntax:
#' ```
#' svc$create_dataset_import_job(
#'   jobName = "string",
#'   datasetArn = "string",
#'   dataSource = list(
#'     dataLocation = "string"
#'   ),
#'   roleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_import_job
personalize_create_dataset_import_job <- function(jobName, datasetArn, dataSource, roleArn) {
  op <- new_operation(
    name = "CreateDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_dataset_import_job_input(jobName = jobName, datasetArn = datasetArn, dataSource = dataSource, roleArn = roleArn)
  output <- .personalize$create_dataset_import_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_import_job <- personalize_create_dataset_import_job

#' Creates an event tracker that you use when sending event data to the
#' specified dataset group using the PutEvents API
#'
#' Creates an event tracker that you use when sending event data to the
#' specified dataset group using the
#' [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
#' API.
#' 
#' When Amazon Personalize creates an event tracker, it also creates an
#' *event-interactions* dataset in the dataset group associated with the
#' event tracker. The event-interactions dataset stores the event data from
#' the `PutEvents` call. The contents of this dataset are not available to
#' the user.
#' 
#' Only one event tracker can be associated with a dataset group. You will
#' get an error if you call `CreateEventTracker` using the same dataset
#' group as an existing event tracker.
#' 
#' When you send event data you include your tracking ID. The tracking ID
#' identifies the customer and authorizes the customer to send the data.
#' 
#' The event tracker can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' -   DELETE PENDING \\> DELETE IN\\_PROGRESS
#' 
#' To get the status of the event tracker, call DescribeEventTracker.
#' 
#' The event tracker must be in the ACTIVE state before using the tracking
#' ID.
#' 
#' **Related APIs**
#' 
#' -   ListEventTrackers
#' 
#' -   DescribeEventTracker
#' 
#' -   DeleteEventTracker
#'
#' @usage
#' personalize_create_event_tracker(name, datasetGroupArn)
#'
#' @param name &#91;required&#93; The name for the event tracker.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that receives the
#' event data.
#'
#' @section Request syntax:
#' ```
#' svc$create_event_tracker(
#'   name = "string",
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_event_tracker
personalize_create_event_tracker <- function(name, datasetGroupArn) {
  op <- new_operation(
    name = "CreateEventTracker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_event_tracker_input(name = name, datasetGroupArn = datasetGroupArn)
  output <- .personalize$create_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_event_tracker <- personalize_create_event_tracker

#' Creates an Amazon Personalize schema from the specified schema string
#'
#' Creates an Amazon Personalize schema from the specified schema string.
#' The schema you create must be in Avro JSON format.
#' 
#' Amazon Personalize recognizes three schema variants. Each schema is
#' associated with a dataset type and has a set of required field and
#' keywords. You specify a schema when you call CreateDataset.
#' 
#' **Related APIs**
#' 
#' -   ListSchemas
#' 
#' -   DescribeSchema
#' 
#' -   DeleteSchema
#'
#' @usage
#' personalize_create_schema(name, schema)
#'
#' @param name &#91;required&#93; The name for the schema.
#' @param schema &#91;required&#93; A schema in Avro JSON format.
#'
#' @section Request syntax:
#' ```
#' svc$create_schema(
#'   name = "string",
#'   schema = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_schema
personalize_create_schema <- function(name, schema) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_schema_input(name = name, schema = schema)
  output <- .personalize$create_schema_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_schema <- personalize_create_schema

#' Creates the configuration for training a model
#'
#' Creates the configuration for training a model. A trained model is known
#' as a solution. After the configuration is created, you train the model
#' (create a solution) by calling the CreateSolutionVersion operation.
#' Every time you call `CreateSolutionVersion`, a new version of the
#' solution is created.
#' 
#' After creating a solution version, you check its accuracy by calling
#' GetSolutionMetrics. When you are satisfied with the version, you deploy
#' it using CreateCampaign. The campaign provides recommendations to a
#' client through the
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' API.
#' 
#' To train a model, Amazon Personalize requires training data and a
#' recipe. The training data comes from the dataset group that you provide
#' in the request. A recipe specifies the training algorithm and a feature
#' transformation. You can specify one of the predefined recipes provided
#' by Amazon Personalize. Alternatively, you can specify `performAutoML`
#' and Amazon Personalize will analyze your data and select the optimum
#' USER\\_PERSONALIZATION recipe for you.
#' 
#' **Status**
#' 
#' A solution can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' -   DELETE PENDING \\> DELETE IN\\_PROGRESS
#' 
#' To get the status of the solution, call DescribeSolution. Wait until the
#' status shows as ACTIVE before calling `CreateSolutionVersion`.
#' 
#' **Related APIs**
#' 
#' -   ListSolutions
#' 
#' -   CreateSolutionVersion
#' 
#' -   DescribeSolution
#' 
#' -   DeleteSolution
#' 
#' <!-- -->
#' 
#' -   ListSolutionVersions
#' 
#' -   DescribeSolutionVersion
#'
#' @usage
#' personalize_create_solution(name, performHPO, performAutoML, recipeArn,
#'   datasetGroupArn, eventType, solutionConfig)
#'
#' @param name &#91;required&#93; The name for the solution.
#' @param performHPO Whether to perform hyperparameter optimization (HPO) on the specified or
#' selected recipe. The default is `false`.
#' 
#' When performing AutoML, this parameter is always `true` and you should
#' not set it to `false`.
#' @param performAutoML Whether to perform automated machine learning (AutoML). The default is
#' `false`. For this case, you must specify `recipeArn`.
#' 
#' When set to `true`, Amazon Personalize analyzes your training data and
#' selects the optimal USER\\_PERSONALIZATION recipe and hyperparameters. In
#' this case, you must omit `recipeArn`. Amazon Personalize determines the
#' optimal recipe by running tests with different values for the
#' hyperparameters. AutoML lengthens the training process as compared to
#' selecting a specific recipe.
#' @param recipeArn The ARN of the recipe to use for model training. Only specified when
#' `performAutoML` is false.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that provides the
#' training data.
#' @param eventType When your have multiple event types (using an `EVENT_TYPE` schema
#' field), this parameter specifies which event type (for example,
#' \'click\' or \'like\') is used for training the model.
#' @param solutionConfig The configuration to use with the solution. When `performAutoML` is set
#' to true, Amazon Personalize only evaluates the `autoMLConfig` section of
#' the solution configuration.
#'
#' @section Request syntax:
#' ```
#' svc$create_solution(
#'   name = "string",
#'   performHPO = TRUE|FALSE,
#'   performAutoML = TRUE|FALSE,
#'   recipeArn = "string",
#'   datasetGroupArn = "string",
#'   eventType = "string",
#'   solutionConfig = list(
#'     eventValueThreshold = "string",
#'     hpoConfig = list(
#'       hpoObjective = list(
#'         type = "string",
#'         metricName = "string",
#'         metricRegex = "string"
#'       ),
#'       hpoResourceConfig = list(
#'         maxNumberOfTrainingJobs = "string",
#'         maxParallelTrainingJobs = "string"
#'       ),
#'       algorithmHyperParameterRanges = list(
#'         integerHyperParameterRanges = list(
#'           list(
#'             name = "string",
#'             minValue = 123,
#'             maxValue = 123
#'           )
#'         ),
#'         continuousHyperParameterRanges = list(
#'           list(
#'             name = "string",
#'             minValue = 123.0,
#'             maxValue = 123.0
#'           )
#'         ),
#'         categoricalHyperParameterRanges = list(
#'           list(
#'             name = "string",
#'             values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     algorithmHyperParameters = list(
#'       "string"
#'     ),
#'     featureTransformationParameters = list(
#'       "string"
#'     ),
#'     autoMLConfig = list(
#'       metricName = "string",
#'       recipeList = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_solution
personalize_create_solution <- function(name, performHPO = NULL, performAutoML = NULL, recipeArn = NULL, datasetGroupArn, eventType = NULL, solutionConfig = NULL) {
  op <- new_operation(
    name = "CreateSolution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_solution_input(name = name, performHPO = performHPO, performAutoML = performAutoML, recipeArn = recipeArn, datasetGroupArn = datasetGroupArn, eventType = eventType, solutionConfig = solutionConfig)
  output <- .personalize$create_solution_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_solution <- personalize_create_solution

#' Trains or retrains an active solution
#'
#' Trains or retrains an active solution. A solution is created using the
#' CreateSolution operation and must be in the ACTIVE state before calling
#' `CreateSolutionVersion`. A new version of the solution is created every
#' time you call this operation.
#' 
#' **Status**
#' 
#' A solution version can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' To get the status of the version, call DescribeSolutionVersion. Wait
#' until the status shows as ACTIVE before calling `CreateCampaign`.
#' 
#' If the status shows as CREATE FAILED, the response includes a
#' `failureReason` key, which describes why the job failed.
#' 
#' **Related APIs**
#' 
#' -   ListSolutionVersions
#' 
#' -   DescribeSolutionVersion
#' 
#' <!-- -->
#' 
#' -   ListSolutions
#' 
#' -   CreateSolution
#' 
#' -   DescribeSolution
#' 
#' -   DeleteSolution
#'
#' @usage
#' personalize_create_solution_version(solutionArn, trainingMode)
#'
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution containing the training
#' configuration information.
#' @param trainingMode The scope of training to be performed when creating the solution
#' version. The `FULL` option trains the solution version based on the
#' entirety of the input solution\'s training data, while the `UPDATE`
#' option processes only the data that has changed in comparison to the
#' input solution. Choose `UPDATE` when you want to incrementally update
#' your solution version instead of creating an entirely new one.
#' 
#' The `UPDATE` option can only be used when you already have an active
#' solution version created from the input solution using the `FULL` option
#' and the input solution was trained with the native-recipe-hrnn-coldstart
#' recipe.
#'
#' @section Request syntax:
#' ```
#' svc$create_solution_version(
#'   solutionArn = "string",
#'   trainingMode = "FULL"|"UPDATE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_solution_version
personalize_create_solution_version <- function(solutionArn, trainingMode = NULL) {
  op <- new_operation(
    name = "CreateSolutionVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_solution_version_input(solutionArn = solutionArn, trainingMode = trainingMode)
  output <- .personalize$create_solution_version_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_solution_version <- personalize_create_solution_version

#' Removes a campaign by deleting the solution deployment
#'
#' Removes a campaign by deleting the solution deployment. The solution
#' that the campaign is based on is not deleted and can be redeployed when
#' needed. A deleted campaign can no longer be specified in a
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' request. For more information on campaigns, see CreateCampaign.
#'
#' @usage
#' personalize_delete_campaign(campaignArn)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_campaign(
#'   campaignArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_campaign
personalize_delete_campaign <- function(campaignArn) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_campaign_input(campaignArn = campaignArn)
  output <- .personalize$delete_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_campaign <- personalize_delete_campaign

#' Deletes a dataset
#'
#' Deletes a dataset. You can\'t delete a dataset if an associated
#' `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN
#' PROGRESS state. For more information on datasets, see CreateDataset.
#'
#' @usage
#' personalize_delete_dataset(datasetArn)
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dataset(
#'   datasetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_dataset
personalize_delete_dataset <- function(datasetArn) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_dataset_input(datasetArn = datasetArn)
  output <- .personalize$delete_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_dataset <- personalize_delete_dataset

#' Deletes a dataset group
#'
#' Deletes a dataset group. Before you delete a dataset group, you must
#' delete the following:
#' 
#' -   All associated event trackers.
#' 
#' -   All associated solutions.
#' 
#' -   All datasets in the dataset group.
#'
#' @usage
#' personalize_delete_dataset_group(datasetGroupArn)
#'
#' @param datasetGroupArn &#91;required&#93; The ARN of the dataset group to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dataset_group(
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_dataset_group
personalize_delete_dataset_group <- function(datasetGroupArn) {
  op <- new_operation(
    name = "DeleteDatasetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_dataset_group_input(datasetGroupArn = datasetGroupArn)
  output <- .personalize$delete_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_dataset_group <- personalize_delete_dataset_group

#' Deletes the event tracker
#'
#' Deletes the event tracker. Does not delete the event-interactions
#' dataset from the associated dataset group. For more information on event
#' trackers, see CreateEventTracker.
#'
#' @usage
#' personalize_delete_event_tracker(eventTrackerArn)
#'
#' @param eventTrackerArn &#91;required&#93; The Amazon Resource Name (ARN) of the event tracker to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_tracker(
#'   eventTrackerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_event_tracker
personalize_delete_event_tracker <- function(eventTrackerArn) {
  op <- new_operation(
    name = "DeleteEventTracker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_event_tracker_input(eventTrackerArn = eventTrackerArn)
  output <- .personalize$delete_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_event_tracker <- personalize_delete_event_tracker

#' Deletes a schema
#'
#' Deletes a schema. Before deleting a schema, you must delete all datasets
#' referencing the schema. For more information on schemas, see
#' CreateSchema.
#'
#' @usage
#' personalize_delete_schema(schemaArn)
#'
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the schema to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_schema(
#'   schemaArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_schema
personalize_delete_schema <- function(schemaArn) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_schema_input(schemaArn = schemaArn)
  output <- .personalize$delete_schema_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_schema <- personalize_delete_schema

#' Deletes all versions of a solution and the Solution object itself
#'
#' Deletes all versions of a solution and the `Solution` object itself.
#' Before deleting a solution, you must delete all campaigns based on the
#' solution. To determine what campaigns are using the solution, call
#' ListCampaigns and supply the Amazon Resource Name (ARN) of the solution.
#' You can\'t delete a solution if an associated `SolutionVersion` is in
#' the CREATE PENDING or IN PROGRESS state. For more information on
#' solutions, see CreateSolution.
#'
#' @usage
#' personalize_delete_solution(solutionArn)
#'
#' @param solutionArn &#91;required&#93; The ARN of the solution to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_solution(
#'   solutionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_solution
personalize_delete_solution <- function(solutionArn) {
  op <- new_operation(
    name = "DeleteSolution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_solution_input(solutionArn = solutionArn)
  output <- .personalize$delete_solution_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_solution <- personalize_delete_solution

#' Describes the given algorithm
#'
#' Describes the given algorithm.
#'
#' @usage
#' personalize_describe_algorithm(algorithmArn)
#'
#' @param algorithmArn &#91;required&#93; The Amazon Resource Name (ARN) of the algorithm to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_algorithm(
#'   algorithmArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_algorithm
personalize_describe_algorithm <- function(algorithmArn) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_algorithm_input(algorithmArn = algorithmArn)
  output <- .personalize$describe_algorithm_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_algorithm <- personalize_describe_algorithm

#' Gets the properties of a batch inference job including name, Amazon
#' Resource Name (ARN), status, input and output configurations, and the
#' ARN of the solution version used to generate the recommendations
#'
#' Gets the properties of a batch inference job including name, Amazon
#' Resource Name (ARN), status, input and output configurations, and the
#' ARN of the solution version used to generate the recommendations.
#'
#' @usage
#' personalize_describe_batch_inference_job(batchInferenceJobArn)
#'
#' @param batchInferenceJobArn &#91;required&#93; The ARN of the batch inference job to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_batch_inference_job(
#'   batchInferenceJobArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_batch_inference_job
personalize_describe_batch_inference_job <- function(batchInferenceJobArn) {
  op <- new_operation(
    name = "DescribeBatchInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_batch_inference_job_input(batchInferenceJobArn = batchInferenceJobArn)
  output <- .personalize$describe_batch_inference_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_batch_inference_job <- personalize_describe_batch_inference_job

#' Describes the given campaign, including its status
#'
#' Describes the given campaign, including its status.
#' 
#' A campaign can be in one of the following states:
#' 
#' -   CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
#' 
#' -   DELETE PENDING \\> DELETE IN\\_PROGRESS
#' 
#' When the `status` is `CREATE FAILED`, the response includes the
#' `failureReason` key, which describes why.
#' 
#' For more information on campaigns, see CreateCampaign.
#'
#' @usage
#' personalize_describe_campaign(campaignArn)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign.
#'
#' @section Request syntax:
#' ```
#' svc$describe_campaign(
#'   campaignArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_campaign
personalize_describe_campaign <- function(campaignArn) {
  op <- new_operation(
    name = "DescribeCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_campaign_input(campaignArn = campaignArn)
  output <- .personalize$describe_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_campaign <- personalize_describe_campaign

#' Describes the given dataset
#'
#' Describes the given dataset. For more information on datasets, see
#' CreateDataset.
#'
#' @usage
#' personalize_describe_dataset(datasetArn)
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset(
#'   datasetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset
personalize_describe_dataset <- function(datasetArn) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_dataset_input(datasetArn = datasetArn)
  output <- .personalize$describe_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset <- personalize_describe_dataset

#' Describes the given dataset group
#'
#' Describes the given dataset group. For more information on dataset
#' groups, see CreateDatasetGroup.
#'
#' @usage
#' personalize_describe_dataset_group(datasetGroupArn)
#'
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset_group(
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_group
personalize_describe_dataset_group <- function(datasetGroupArn) {
  op <- new_operation(
    name = "DescribeDatasetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_dataset_group_input(datasetGroupArn = datasetGroupArn)
  output <- .personalize$describe_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_group <- personalize_describe_dataset_group

#' Describes the dataset import job created by CreateDatasetImportJob,
#' including the import job status
#'
#' Describes the dataset import job created by CreateDatasetImportJob,
#' including the import job status.
#'
#' @usage
#' personalize_describe_dataset_import_job(datasetImportJobArn)
#'
#' @param datasetImportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset import job to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset_import_job(
#'   datasetImportJobArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_import_job
personalize_describe_dataset_import_job <- function(datasetImportJobArn) {
  op <- new_operation(
    name = "DescribeDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_dataset_import_job_input(datasetImportJobArn = datasetImportJobArn)
  output <- .personalize$describe_dataset_import_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_import_job <- personalize_describe_dataset_import_job

#' Describes an event tracker
#'
#' Describes an event tracker. The response includes the `trackingId` and
#' `status` of the event tracker. For more information on event trackers,
#' see CreateEventTracker.
#'
#' @usage
#' personalize_describe_event_tracker(eventTrackerArn)
#'
#' @param eventTrackerArn &#91;required&#93; The Amazon Resource Name (ARN) of the event tracker to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_tracker(
#'   eventTrackerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_event_tracker
personalize_describe_event_tracker <- function(eventTrackerArn) {
  op <- new_operation(
    name = "DescribeEventTracker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_event_tracker_input(eventTrackerArn = eventTrackerArn)
  output <- .personalize$describe_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_event_tracker <- personalize_describe_event_tracker

#' Describes the given feature transformation
#'
#' Describes the given feature transformation.
#'
#' @usage
#' personalize_describe_feature_transformation(featureTransformationArn)
#'
#' @param featureTransformationArn &#91;required&#93; The Amazon Resource Name (ARN) of the feature transformation to
#' describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_feature_transformation(
#'   featureTransformationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_feature_transformation
personalize_describe_feature_transformation <- function(featureTransformationArn) {
  op <- new_operation(
    name = "DescribeFeatureTransformation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_feature_transformation_input(featureTransformationArn = featureTransformationArn)
  output <- .personalize$describe_feature_transformation_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_feature_transformation <- personalize_describe_feature_transformation

#' Describes a recipe
#'
#' Describes a recipe.
#' 
#' A recipe contains three items:
#' 
#' -   An algorithm that trains a model.
#' 
#' -   Hyperparameters that govern the training.
#' 
#' -   Feature transformation information for modifying the input data
#'     before training.
#' 
#' Amazon Personalize provides a set of predefined recipes. You specify a
#' recipe when you create a solution with the CreateSolution API.
#' `CreateSolution` trains a model by using the algorithm in the specified
#' recipe and a training dataset. The solution, when deployed as a
#' campaign, can provide recommendations using the
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' API.
#'
#' @usage
#' personalize_describe_recipe(recipeArn)
#'
#' @param recipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the recipe to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_recipe(
#'   recipeArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_recipe
personalize_describe_recipe <- function(recipeArn) {
  op <- new_operation(
    name = "DescribeRecipe",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_recipe_input(recipeArn = recipeArn)
  output <- .personalize$describe_recipe_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_recipe <- personalize_describe_recipe

#' Describes a schema
#'
#' Describes a schema. For more information on schemas, see CreateSchema.
#'
#' @usage
#' personalize_describe_schema(schemaArn)
#'
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the schema to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_schema(
#'   schemaArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_schema
personalize_describe_schema <- function(schemaArn) {
  op <- new_operation(
    name = "DescribeSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_schema_input(schemaArn = schemaArn)
  output <- .personalize$describe_schema_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_schema <- personalize_describe_schema

#' Describes a solution
#'
#' Describes a solution. For more information on solutions, see
#' CreateSolution.
#'
#' @usage
#' personalize_describe_solution(solutionArn)
#'
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_solution(
#'   solutionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_solution
personalize_describe_solution <- function(solutionArn) {
  op <- new_operation(
    name = "DescribeSolution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_solution_input(solutionArn = solutionArn)
  output <- .personalize$describe_solution_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_solution <- personalize_describe_solution

#' Describes a specific version of a solution
#'
#' Describes a specific version of a solution. For more information on
#' solutions, see CreateSolution.
#'
#' @usage
#' personalize_describe_solution_version(solutionVersionArn)
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version.
#'
#' @section Request syntax:
#' ```
#' svc$describe_solution_version(
#'   solutionVersionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_solution_version
personalize_describe_solution_version <- function(solutionVersionArn) {
  op <- new_operation(
    name = "DescribeSolutionVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_solution_version_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$describe_solution_version_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_solution_version <- personalize_describe_solution_version

#' Gets the metrics for the specified solution version
#'
#' Gets the metrics for the specified solution version.
#'
#' @usage
#' personalize_get_solution_metrics(solutionVersionArn)
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version for which to get
#' metrics.
#'
#' @section Request syntax:
#' ```
#' svc$get_solution_metrics(
#'   solutionVersionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_get_solution_metrics
personalize_get_solution_metrics <- function(solutionVersionArn) {
  op <- new_operation(
    name = "GetSolutionMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$get_solution_metrics_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$get_solution_metrics_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$get_solution_metrics <- personalize_get_solution_metrics

#' Gets a list of the batch inference jobs that have been performed off of
#' a solution version
#'
#' Gets a list of the batch inference jobs that have been performed off of
#' a solution version.
#'
#' @usage
#' personalize_list_batch_inference_jobs(solutionVersionArn, nextToken,
#'   maxResults)
#'
#' @param solutionVersionArn The Amazon Resource Name (ARN) of the solution version from which the
#' batch inference jobs were created.
#' @param nextToken The token to request the next page of results.
#' @param maxResults The maximum number of batch inference job results to return in each
#' page. The default value is 100.
#'
#' @section Request syntax:
#' ```
#' svc$list_batch_inference_jobs(
#'   solutionVersionArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_batch_inference_jobs
personalize_list_batch_inference_jobs <- function(solutionVersionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListBatchInferenceJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_batch_inference_jobs_input(solutionVersionArn = solutionVersionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_batch_inference_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_batch_inference_jobs <- personalize_list_batch_inference_jobs

#' Returns a list of campaigns that use the given solution
#'
#' Returns a list of campaigns that use the given solution. When a solution
#' is not specified, all the campaigns associated with the account are
#' listed. The response provides the properties for each campaign,
#' including the Amazon Resource Name (ARN). For more information on
#' campaigns, see CreateCampaign.
#'
#' @usage
#' personalize_list_campaigns(solutionArn, nextToken, maxResults)
#'
#' @param solutionArn The Amazon Resource Name (ARN) of the solution to list the campaigns
#' for. When a solution is not specified, all the campaigns associated with
#' the account are listed.
#' @param nextToken A token returned from the previous call to `ListCampaigns` for getting
#' the next set of campaigns (if they exist).
#' @param maxResults The maximum number of campaigns to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_campaigns(
#'   solutionArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_campaigns
personalize_list_campaigns <- function(solutionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListCampaigns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_campaigns_input(solutionArn = solutionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_campaigns_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_campaigns <- personalize_list_campaigns

#' Returns a list of dataset groups
#'
#' Returns a list of dataset groups. The response provides the properties
#' for each dataset group, including the Amazon Resource Name (ARN). For
#' more information on dataset groups, see CreateDatasetGroup.
#'
#' @usage
#' personalize_list_dataset_groups(nextToken, maxResults)
#'
#' @param nextToken A token returned from the previous call to `ListDatasetGroups` for
#' getting the next set of dataset groups (if they exist).
#' @param maxResults The maximum number of dataset groups to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_dataset_groups(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_groups
personalize_list_dataset_groups <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_dataset_groups_input(nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_groups_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_groups <- personalize_list_dataset_groups

#' Returns a list of dataset import jobs that use the given dataset
#'
#' Returns a list of dataset import jobs that use the given dataset. When a
#' dataset is not specified, all the dataset import jobs associated with
#' the account are listed. The response provides the properties for each
#' dataset import job, including the Amazon Resource Name (ARN). For more
#' information on dataset import jobs, see CreateDatasetImportJob. For more
#' information on datasets, see CreateDataset.
#'
#' @usage
#' personalize_list_dataset_import_jobs(datasetArn, nextToken, maxResults)
#'
#' @param datasetArn The Amazon Resource Name (ARN) of the dataset to list the dataset import
#' jobs for.
#' @param nextToken A token returned from the previous call to `ListDatasetImportJobs` for
#' getting the next set of dataset import jobs (if they exist).
#' @param maxResults The maximum number of dataset import jobs to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_dataset_import_jobs(
#'   datasetArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_import_jobs
personalize_list_dataset_import_jobs <- function(datasetArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetImportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_dataset_import_jobs_input(datasetArn = datasetArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_import_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_import_jobs <- personalize_list_dataset_import_jobs

#' Returns the list of datasets contained in the given dataset group
#'
#' Returns the list of datasets contained in the given dataset group. The
#' response provides the properties for each dataset, including the Amazon
#' Resource Name (ARN). For more information on datasets, see
#' CreateDataset.
#'
#' @usage
#' personalize_list_datasets(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group that contains the
#' datasets to list.
#' @param nextToken A token returned from the previous call to `ListDatasetImportJobs` for
#' getting the next set of dataset import jobs (if they exist).
#' @param maxResults The maximum number of datasets to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_datasets(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_datasets
personalize_list_datasets <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_datasets_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_datasets_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_datasets <- personalize_list_datasets

#' Returns the list of event trackers associated with the account
#'
#' Returns the list of event trackers associated with the account. The
#' response provides the properties for each event tracker, including the
#' Amazon Resource Name (ARN) and tracking ID. For more information on
#' event trackers, see CreateEventTracker.
#'
#' @usage
#' personalize_list_event_trackers(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The ARN of a dataset group used to filter the response.
#' @param nextToken A token returned from the previous call to `ListEventTrackers` for
#' getting the next set of event trackers (if they exist).
#' @param maxResults The maximum number of event trackers to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_event_trackers(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_event_trackers
personalize_list_event_trackers <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventTrackers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_event_trackers_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_event_trackers_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_event_trackers <- personalize_list_event_trackers

#' Returns a list of available recipes
#'
#' Returns a list of available recipes. The response provides the
#' properties for each recipe, including the recipe\'s Amazon Resource Name
#' (ARN).
#'
#' @usage
#' personalize_list_recipes(recipeProvider, nextToken, maxResults)
#'
#' @param recipeProvider The default is `SERVICE`.
#' @param nextToken A token returned from the previous call to `ListRecipes` for getting the
#' next set of recipes (if they exist).
#' @param maxResults The maximum number of recipes to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_recipes(
#'   recipeProvider = "SERVICE",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_recipes
personalize_list_recipes <- function(recipeProvider = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRecipes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_recipes_input(recipeProvider = recipeProvider, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_recipes_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_recipes <- personalize_list_recipes

#' Returns the list of schemas associated with the account
#'
#' Returns the list of schemas associated with the account. The response
#' provides the properties for each schema, including the Amazon Resource
#' Name (ARN). For more information on schemas, see CreateSchema.
#'
#' @usage
#' personalize_list_schemas(nextToken, maxResults)
#'
#' @param nextToken A token returned from the previous call to `ListSchemas` for getting the
#' next set of schemas (if they exist).
#' @param maxResults The maximum number of schemas to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_schemas(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_schemas
personalize_list_schemas <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_schemas_input(nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_schemas_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_schemas <- personalize_list_schemas

#' Returns a list of solution versions for the given solution
#'
#' Returns a list of solution versions for the given solution. When a
#' solution is not specified, all the solution versions associated with the
#' account are listed. The response provides the properties for each
#' solution version, including the Amazon Resource Name (ARN). For more
#' information on solutions, see CreateSolution.
#'
#' @usage
#' personalize_list_solution_versions(solutionArn, nextToken, maxResults)
#'
#' @param solutionArn The Amazon Resource Name (ARN) of the solution.
#' @param nextToken A token returned from the previous call to `ListSolutionVersions` for
#' getting the next set of solution versions (if they exist).
#' @param maxResults The maximum number of solution versions to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_solution_versions(
#'   solutionArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_solution_versions
personalize_list_solution_versions <- function(solutionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSolutionVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_solution_versions_input(solutionArn = solutionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_solution_versions_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_solution_versions <- personalize_list_solution_versions

#' Returns a list of solutions that use the given dataset group
#'
#' Returns a list of solutions that use the given dataset group. When a
#' dataset group is not specified, all the solutions associated with the
#' account are listed. The response provides the properties for each
#' solution, including the Amazon Resource Name (ARN). For more information
#' on solutions, see CreateSolution.
#'
#' @usage
#' personalize_list_solutions(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group.
#' @param nextToken A token returned from the previous call to `ListSolutions` for getting
#' the next set of solutions (if they exist).
#' @param maxResults The maximum number of solutions to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_solutions(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_solutions
personalize_list_solutions <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSolutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_solutions_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_solutions_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_solutions <- personalize_list_solutions

#' Updates a campaign by either deploying a new solution or changing the
#' value of the campaign's minProvisionedTPS parameter
#'
#' Updates a campaign by either deploying a new solution or changing the
#' value of the campaign\'s `minProvisionedTPS` parameter.
#' 
#' To update a campaign, the campaign status must be ACTIVE or CREATE
#' FAILED. Check the campaign status using the DescribeCampaign API.
#' 
#' You must wait until the `status` of the updated campaign is `ACTIVE`
#' before asking the campaign for recommendations.
#' 
#' For more information on campaigns, see CreateCampaign.
#'
#' @usage
#' personalize_update_campaign(campaignArn, solutionVersionArn,
#'   minProvisionedTPS)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign.
#' @param solutionVersionArn The ARN of a new solution version to deploy.
#' @param minProvisionedTPS Specifies the requested minimum provisioned transactions
#' (recommendations) per second that Amazon Personalize will support.
#'
#' @section Request syntax:
#' ```
#' svc$update_campaign(
#'   campaignArn = "string",
#'   solutionVersionArn = "string",
#'   minProvisionedTPS = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_update_campaign
personalize_update_campaign <- function(campaignArn, solutionVersionArn = NULL, minProvisionedTPS = NULL) {
  op <- new_operation(
    name = "UpdateCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$update_campaign_input(campaignArn = campaignArn, solutionVersionArn = solutionVersionArn, minProvisionedTPS = minProvisionedTPS)
  output <- .personalize$update_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_campaign <- personalize_update_campaign
