% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_create_studio}
\alias{emr_create_studio}
\title{Creates a new Amazon EMR Studio}
\usage{
emr_create_studio(
  Name,
  Description = NULL,
  AuthMode,
  VpcId,
  SubnetIds,
  ServiceRole,
  UserRole = NULL,
  WorkspaceSecurityGroupId,
  EngineSecurityGroupId,
  DefaultS3Location,
  IdpAuthUrl = NULL,
  IdpRelayStateParameterName = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] A descriptive name for the Amazon EMR Studio.}

\item{Description}{A detailed description of the Amazon EMR Studio.}

\item{AuthMode}{[required] Specifies whether the Studio authenticates users using IAM or IAM
Identity Center.}

\item{VpcId}{[required] The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate
with the Studio.}

\item{SubnetIds}{[required] A list of subnet IDs to associate with the Amazon EMR Studio. A Studio
can have a maximum of 5 subnets. The subnets must belong to the VPC
specified by \code{VpcId}. Studio users can create a Workspace in any of the
specified subnets.}

\item{ServiceRole}{[required] The IAM role that the Amazon EMR Studio assumes. The service role
provides a way for Amazon EMR Studio to interoperate with other Amazon
Web Services services.}

\item{UserRole}{The IAM user role that users and groups assume when logged in to an
Amazon EMR Studio. Only specify a \code{UserRole} when you use IAM Identity
Center authentication. The permissions attached to the \code{UserRole} can be
scoped down for each user or group using session policies.}

\item{WorkspaceSecurityGroupId}{[required] The ID of the Amazon EMR Studio Workspace security group. The Workspace
security group allows outbound network traffic to resources in the
Engine security group, and it must be in the same VPC specified by
\code{VpcId}.}

\item{EngineSecurityGroupId}{[required] The ID of the Amazon EMR Studio Engine security group. The Engine
security group allows inbound network traffic from the Workspace
security group, and it must be in the same VPC specified by \code{VpcId}.}

\item{DefaultS3Location}{[required] The Amazon S3 location to back up Amazon EMR Studio Workspaces and
notebook files.}

\item{IdpAuthUrl}{The authentication endpoint of your identity provider (IdP). Specify
this value when you use IAM authentication and want to let federated
users log in to a Studio with the Studio URL and credentials from your
IdP. Amazon EMR Studio redirects users to this endpoint to enter
credentials.}

\item{IdpRelayStateParameterName}{The name that your identity provider (IdP) uses for its \code{RelayState}
parameter. For example, \code{RelayState} or \code{TargetSource}. Specify this
value when you use IAM authentication and want to let federated users
log in to a Studio using the Studio URL. The \code{RelayState} parameter
differs by IdP.}

\item{Tags}{A list of tags to associate with the Amazon EMR Studio. Tags are
user-defined key-value pairs that consist of a required key string with
a maximum of 128 characters, and an optional value string with a maximum
of 256 characters.}
}
\description{
Creates a new Amazon EMR Studio.

See \url{https://www.paws-r-sdk.com/docs/emr_create_studio/} for full documentation.
}
\keyword{internal}
